part of 'coordinator_save_bloc.dart';

abstract class CoordinatorSaveState extends Equatable {
  const CoordinatorSaveState();

  @override
  List<Object> get props => [];
}

class CoordinatorSaveInitial extends CoordinatorSaveState {
  @override
  List<Object> get props => [];
}

class CoordinatorSaveLoading extends CoordinatorSaveState {}

class CoordinatorSaveLoaded extends CoordinatorSaveState {
  final CoordinatorModel result;
  final List<CoordinatorPositionModel> positionList;
  final bool saveSuccess;
  final String errorMessage;

  CoordinatorSaveLoaded({
    this.result,
    this.positionList,
    this.saveSuccess,
    this.errorMessage,
  });
  @override
  List<Object> get props => [result, positionList, saveSuccess];
}

class CoordinatorSaveNotFound extends CoordinatorSaveState {}

class CoordinatorSaveError extends CoordinatorSaveState {
  final String message;
  const CoordinatorSaveError({this.message});
  @override
  List<Object> get props => [message];
}

class CoordinatorSaveErrorUnauthorized extends CoordinatorSaveState {}
