part of 'coordinator_list_bloc.dart';

abstract class CoordinatorListState extends Equatable {
  const CoordinatorListState();

  @override
  List<Object> get props => [];
}

class CoordinatorListInitial extends CoordinatorListState {
  @override
  List<Object> get props => [];
}

class CoordinatorListLoading extends CoordinatorListState {}

class CoordinatorListLoaded extends CoordinatorListState {
  final List<CoordinatorModel> result;
  final bool deleteSuccess;

  CoordinatorListLoaded({
    this.result,
    this.deleteSuccess,
  });
  @override
  List<Object> get props => [result, deleteSuccess];
}

class CoordinatorListNotFound extends CoordinatorListState {}

class CoordinatorListError extends CoordinatorListState {
  final String message;
  const CoordinatorListError({this.message});
  @override
  List<Object> get props => [message];
}

class CoordinatorListErrorUnauthorized extends CoordinatorListState {}
