part of 'chat_room_list_bloc.dart';

abstract class ChatRoomListState extends Equatable {
  const ChatRoomListState();

  @override
  List<Object> get props => [];
}

class ChatRoomListInitial extends ChatRoomListState {
  @override
  List<Object> get props => [];
}

class ChatRoomListLoading extends ChatRoomListState {}

class ChatRoomListLoaded extends ChatRoomListState {
  final List<ChatRoomModel> result;
  final bool deleteSuccess;

  ChatRoomListLoaded({
    this.result,
    this.deleteSuccess,
  });
  @override
  List<Object> get props => [result, deleteSuccess];
}

class ChatRoomListNotFound extends ChatRoomListState {}

class ChatRoomListError extends ChatRoomListState {
  final String message;
  const ChatRoomListError({this.message});
  @override
  List<Object> get props => [message];
}

class ChatRoomListErrorUnauthorized extends ChatRoomListState {}
