import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/chat_reader_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/chat_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'chat_reader_list_event.dart';
part 'chat_reader_list_state.dart';

class ChatReaderListBloc extends Bloc<ChatReaderListEvent, ChatReaderListState> {
  ChatImpService service = ChatImpService();
  ResultData resultData;

  ChatReaderListBloc() : super(ChatReaderListInitial());

  @override
  Stream<ChatReaderListState> mapEventToState(ChatReaderListEvent event) async* {
    try {
      if (event is ChatReaderListGetList) {
        yield ChatReaderListLoading();
        resultData = await service.getChatReaderList(
          messageId: event.messageId,
          customerName: ShareDataUtil.getCustomerName(),
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield ChatReaderListErrorUnauthorized();
        } else {
          yield ChatReaderListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield ChatReaderListError(message: "Error");
    }
  }
}
