part of 'chat_menu_badge_count_bloc.dart';

abstract class ChatMenuBadgeCountState extends Equatable {
  const ChatMenuBadgeCountState();

  @override
  List<Object> get props => [];
}

class ChatMenuBadgeCountInitial extends ChatMenuBadgeCountState {}

class ChatMenuBadgeCountLoading extends ChatMenuBadgeCountState {}

class ChatMenuBadgeCountLoaded extends ChatMenuBadgeCountState {
  final int result;
  final DateTime lastUpdate;

  ChatMenuBadgeCountLoaded({
    this.result,
    this.lastUpdate,
  });
  @override
  List<Object> get props => [result, lastUpdate];
}

class ChatMenuBadgeCountNotFound extends ChatMenuBadgeCountState {}

class ChatMenuBadgeCountError extends ChatMenuBadgeCountState {
  final String message;
  const ChatMenuBadgeCountError({this.message});
  @override
  List<Object> get props => [message];
}
