import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';

part 'chat_menu_badge_count_event.dart';
part 'chat_menu_badge_count_state.dart';

class ChatMenuBadgeCountBloc extends Bloc<ChatMenuBadgeCountEvent, ChatMenuBadgeCountState> {
  ChatMenuBadgeCountBloc() : super(ChatMenuBadgeCountInitial());

  @override
  Stream<ChatMenuBadgeCountState> mapEventToState(ChatMenuBadgeCountEvent event) async* {
    try {
      if (event is ChatMenuBadgeCountGetData) {
        yield ChatMenuBadgeCountLoaded(result: 0, lastUpdate: DateTime.now());
      } else if (event is ChatMenuBadgeCountAddCount) {
        yield ChatMenuBadgeCountLoaded(result: event.count, lastUpdate: DateTime.now());
      }
    } catch (e) {
      yield ChatMenuBadgeCountError(message: "เกิดข้อผิดพลาด");
    }
  }
}
