part of 'chat_list_bloc.dart';

abstract class ChatListEvent extends Equatable {
  const ChatListEvent();

  @override
  List<Object> get props => [];
}

class ChatListGetList extends ChatListEvent {
  final bool isGroupChat;
  final bool isNewMessage;
  final String typeChat;
  final String chatMasterId;
  final String typeAccount;
  final int currentPage;

  ChatListGetList({
    this.isGroupChat = false,
    this.isNewMessage = false,
    this.typeChat,
    this.chatMasterId,
    this.typeAccount,
    this.currentPage = 1,
  });
}

class ChatListNewMessage extends ChatListEvent {
  final bool isGroupChat;

  ChatListNewMessage({
    this.isGroupChat = false,
  });
}

class ChatListOnSendMessage extends ChatListEvent {
  final String content;
  final int type;
  final String chatMasterId;
  final String typeAccount;
  final String typeChat;
  final bool isGroupChat;
  final String fileType;
  final String fileName;

  ChatListOnSendMessage({
    this.content,
    this.type,
    this.chatMasterId,
    this.typeAccount,
    this.typeChat,
    this.isGroupChat = false,
    this.fileType,
    this.fileName,
  });

  @override
  List<Object> get props => [content, type];
}

class ChatListClear extends ChatListEvent {}
