part of 'additional_service_list_bloc.dart';

abstract class AdditionalServiceListState extends Equatable {
  const AdditionalServiceListState();
  @override
  List<Object> get props => [];
}

class AdditionalServiceListInitial extends AdditionalServiceListState {
  @override
  List<Object> get props => [];
}

class AdditionalServiceListLoading extends AdditionalServiceListState {}

class AdditionalServiceListLoaded extends AdditionalServiceListState {
  final List<AdditionalServiceModel> result;
  AdditionalServiceListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class AdditionalServiceListNotFound extends AdditionalServiceListState {}

class AdditionalServiceListError extends AdditionalServiceListState {
  final String message;
  const AdditionalServiceListError({this.message});
  @override
  List<Object> get props => [message];
}

class AdditionalServiceListErrorUnauthorized extends AdditionalServiceListState {}
