import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/additional_service_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/additional_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'additional_service_list_event.dart';
part 'additional_service_list_state.dart';

class AdditionalServiceListBloc extends Bloc<AdditionalServiceListEvent, AdditionalServiceListState> {
  AdditionalImpService service = AdditionalImpService();

  ResultData resultData;

  AdditionalServiceListBloc() : super(AdditionalServiceListInitial());

  @override
  Stream<AdditionalServiceListState> mapEventToState(AdditionalServiceListEvent event) async* {
    try {
      if (event is AdditionalServiceListGetList) {
        yield AdditionalServiceListLoading();

        resultData = await service.getList(
          customerId: ShareDataUtil.getCustomerId(),
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield AdditionalServiceListErrorUnauthorized();
        } else {
          yield AdditionalServiceListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      print(e);
      yield AdditionalServiceListError(message: "Error");
    }
  }
}
