part of 'additional_service_history_bloc.dart';

abstract class AdditionalServiceHistoryState extends Equatable {
  const AdditionalServiceHistoryState();

  @override
  List<Object> get props => [];
}

class AdditionalServiceHistoryInitial extends AdditionalServiceHistoryState {
  @override
  List<Object> get props => [];
}

class AdditionalServiceHistoryLoading extends AdditionalServiceHistoryState {}

class AdditionalServiceHistoryLoaded extends AdditionalServiceHistoryState {
  final List<AdditionalServiceHistoryModel> result;
  final bool deleteSuccess;

  AdditionalServiceHistoryLoaded({
    this.result,
    this.deleteSuccess,
  });
  @override
  List<Object> get props => [result, deleteSuccess];
}

class AdditionalServiceHistoryNotFound extends AdditionalServiceHistoryState {}

class AdditionalServiceHistoryError extends AdditionalServiceHistoryState {
  final String message;
  const AdditionalServiceHistoryError({this.message});
  @override
  List<Object> get props => [message];
}

class AdditionalServiceHistoryErrorUnauthorized extends AdditionalServiceHistoryState {}
