part of 'additional_service_detail_bloc.dart';

abstract class AdditionalServiceDetailState extends Equatable {
  const AdditionalServiceDetailState();

  @override
  List<Object> get props => [];
}

class AdditionalServiceDetailInitial extends AdditionalServiceDetailState {
  @override
  List<Object> get props => [];
}

class AdditionalServiceDetailLoading extends AdditionalServiceDetailState {}

class AdditionalServiceDetailLoaded extends AdditionalServiceDetailState {
  final AdditionalServiceModel result;
  final bool saveSuccess;

  AdditionalServiceDetailLoaded({
    this.result,
    this.saveSuccess,
  });
  @override
  List<Object> get props => [result, saveSuccess];
}

class AdditionalServiceDetailNotFound extends AdditionalServiceDetailState {}

class AdditionalServiceDetailError extends AdditionalServiceDetailState {
  final String message;
  const AdditionalServiceDetailError({this.message});
  @override
  List<Object> get props => [message];
}

class AdditionalServiceDetailErrorUnauthorized extends AdditionalServiceDetailState {}
