import 'package:flutter/material.dart';
import 'package:peasmartcare/constraints/app_data.dart';

class NotFoundBox extends StatelessWidget {
  final String name;
  final icon;

  const NotFoundBox({
    Key key,
    this.name = "ไม่พบข้อมูล",
    this.icon = Icons.search,
  }) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return Container(
      width: 200,
      height: 200,
      // decoration: BoxDecoration(
      //   color: Colors.grey.withOpacity(0.45),
      //   borderRadius: BorderRadius.all(Radius.circular(20)),
      // ),
      child: Center(
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            Icon(
              icon,
              size: 60,
              color: Color(AppData.purpleColor),
            ),
            Padding(
              padding: const EdgeInsets.only(top: 10),
              child: Text(
                name,
                style: TextStyle(
                  fontSize: 20,
                  color: Color(AppData.purpleColor),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
