import 'package:flutter/material.dart';
import 'package:peasmartcare/widgets/empty_box.dart';

const double ICON_OFF = 0;
const double ICON_ON = -2;
const double TEXT_OFF = 1;
const double TEXT_ON = 1;
const double ALPHA_OFF = 0;
const double ALPHA_ON = 1;
const int ANIM_DURATION = 300;

class TabItem extends StatelessWidget {
  TabItem({
    @required this.uniqueKey,
    @required this.selected,
    // @required this.iconData,
    this.icon,
    this.imageIcon,
    this.badgeCount,
    this.isShowBadgeCount = true,
    @required this.title,
    @required this.callbackFunction,
    @required this.textColor,
    @required this.iconColor,
  });

  final UniqueKey uniqueKey;
  final String title;
  // final IconData iconData;
  final Widget badgeCount;
  final bool isShowBadgeCount;
  final Icon icon;
  final Widget imageIcon;
  final bool selected;
  final Function(UniqueKey uniqueKey) callbackFunction;
  final Color textColor;
  final Color iconColor;

  final double iconYAlign = ICON_ON;
  final double textYAlign = TEXT_OFF;
  final double iconAlpha = ALPHA_ON;

  @override
  Widget build(BuildContext context) {
    return Expanded(
      child: Stack(
        fit: StackFit.expand,
        children: [
          Container(
            height: double.infinity,
            width: double.infinity,
            child: AnimatedAlign(
              duration: Duration(milliseconds: ANIM_DURATION),
              alignment: Alignment(0, (selected) ? TEXT_ON : TEXT_OFF),
              child: Padding(
                padding: const EdgeInsets.all(8),
                child: InkWell(
                  child: Text(
                    title,
                    overflow: TextOverflow.ellipsis,
                    maxLines: 1,
                    style: TextStyle(fontWeight: FontWeight.w600, color: textColor),
                  ),
                  onTap: () {
                    callbackFunction(uniqueKey);
                  },
                ),
              ),
            ),
          ),
          Container(
            height: double.infinity,
            width: double.infinity,
            child: AnimatedAlign(
              duration: Duration(milliseconds: ANIM_DURATION),
              curve: Curves.easeIn,
              alignment: Alignment(0, (selected) ? ICON_OFF : ICON_ON),
              child: AnimatedOpacity(
                duration: Duration(milliseconds: ANIM_DURATION),
                opacity: (selected) ? ALPHA_OFF : ALPHA_ON,
                child: Stack(
                  children: [
                    IconButton(
                      highlightColor: Colors.transparent,
                      splashColor: Colors.transparent,
                      padding: EdgeInsets.all(0),
                      alignment: Alignment(0, 0),
                      icon: imageIcon != null
                          ? SizedBox(
                              height: 30,
                              width: 30,
                              child: imageIcon,
                            )
                          : icon,
                      onPressed: () {
                        callbackFunction(uniqueKey);
                      },
                    ),
                    (!selected && badgeCount != null && isShowBadgeCount)
                        ? Positioned(
                            top: 0,
                            right: 0,
                            child: InkWell(
                              child: Container(
                                padding: EdgeInsets.all(1),
                                decoration: BoxDecoration(
                                  color: Colors.red,
                                  borderRadius: BorderRadius.circular(50),
                                ),
                                constraints: BoxConstraints(
                                  minWidth: 25,
                                  minHeight: 25,
                                ),
                                // child: Text(
                                //   badgeCount.toString(),
                                //   style: TextStyle(
                                //     color: Colors.white,
                                //     fontSize: 15,
                                //   ),
                                //   textAlign: TextAlign.center,
                                // ),
                                child: badgeCount,
                              ),
                              onTap: () {
                                callbackFunction(uniqueKey);
                              },
                            ),
                          )
                        : SizedBox(
                            height: 25,
                            width: 25,
                          ),
                  ],
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
