import 'package:peasmartcare/models/customer_info_model.dart';
import 'package:peasmartcare/models/user_model.dart';
import 'package:shared_preferences/shared_preferences.dart';

class ShareDataUtil {
  static ShareDataUtil _shareDataUtil;

  static SharedPreferences _prefs;

  static Future<ShareDataUtil> getInstance() async {
    if (_shareDataUtil == null) {
      // keep local instance till it is fully initialized.
      var secureStorage = ShareDataUtil._();
      await secureStorage._init();
      _shareDataUtil = secureStorage;
    }
    return _shareDataUtil;
  }

  ShareDataUtil._();

  Future _init() async {
    _prefs = await SharedPreferences.getInstance();
  }

  static Future<bool> setLogin(bool isSuccess) {
    return _prefs.setBool("isLogin", isSuccess);
  }

  static bool isLogin() {
    try {
      return _prefs.getBool("isLogin") == null ? false : true;
    } catch (e) {
      return false;
    }
  }

  static String getUserId() {
    return _prefs?.getString("userId") ?? null;
  }

  static Future<bool> setAuthenKey(String val) {
    return _prefs.setString("authenKey", val);
  }

  static String getAuthenKey() {
    return _prefs?.getString("authenKey") ?? null;
  }

  static Future<bool> setFirebaseToken(String val) {
    return _prefs.setString("firebaseToken", val);
  }

  static String getFirebaseToken() {
    return _prefs?.getString("firebaseToken") ?? null;
  }

  static String getCustomerId() {
    return _prefs?.getString("customerId") ?? null;
  }

  static String getCustomerName() {
    return _prefs?.getString("customerName") ?? null;
  }

  static List<String> getAllChatMasterId() {
    return _prefs?.getStringList("allChatMasterId") ?? [];
  }

  static Future<bool> setAllChatMasterId(String val) {
    List<String> list = getAllChatMasterId();
    list = list.toSet().toList();
    list.add(val);
    return _prefs.setStringList("allChatMasterId", list);
  }

  static Future<bool> clearAllChatMasterId() {
    return _prefs.setStringList("allChatMasterId", []);
  }

  static Future<bool> setCustomerInfo(CustomerInfoModel customerInfo) async {
    _prefs.setString("customerId", customerInfo.customerId);
    _prefs.setString("caNumber", customerInfo.caNumber);
    _prefs.setString("customerName", customerInfo.customerName);
    _prefs.setString("companyAddress", customerInfo.address);
    _prefs.setString("tsit", customerInfo.tsit);
    _prefs.setString("tsitName", customerInfo.tsitName);
    _prefs.setString("peaRegionId", customerInfo.peaRegionId);
    _prefs.setString("peaRegion", customerInfo.peaRegion);

    return true;
  }

  static Future<CustomerInfoModel> getCustomerInfo() {
    CustomerInfoModel customer = CustomerInfoModel();

    _prefs.reload();

    customer.caNumber = _prefs?.getString("caNumber") ?? null;

    if (customer.caNumber != null) {
      customer.customerId = _prefs?.getString("customerId") ?? "";
      customer.customerName = _prefs?.getString("customerName") ?? "";
      customer.address = _prefs?.getString("companyAddress") ?? "";
      customer.tsit = _prefs?.getString("tsit") ?? "";
      customer.tsitName = _prefs?.getString("tsitName") ?? "";
      customer.peaRegionId = _prefs?.getString("peaRegionId") ?? "";
      customer.peaRegion = _prefs?.getString("peaRegion") ?? "";

      return Future(() {
        return customer;
      });
      // return customer;
    }

    return null;
  }

  static Future<bool> setUserInfo(UserModel user) async {
    _prefs.setString("userId", user.id);
    _prefs.setString("firstname", user.firstname);
    _prefs.setString("lastname", user.lastname);
    _prefs.setString("idCard", user.idCard);
    _prefs.setString("phone", user.phone);

    return true;
  }

  static UserModel getUserInfo() {
    UserModel user = UserModel();
    user.id = _prefs?.getString("userId") ?? null;
    if (user.id != null) {
      user.firstname = _prefs.getString("firstname");
      user.lastname = _prefs.getString("lastname");
      user.idCard = _prefs.getString("idCard");
      user.phone = _prefs.getString("phone");
      return user;
    }

    return null;
  }

  static String getFullname() {
    return "${_prefs.getString("firstname")} ${_prefs.getString("lastname")}";
  }

  static String getIdCard() {
    return _prefs?.getString("idCard") ?? null;
  }

  static String getCaNumber() {
    return _prefs?.getString("caNumber") ?? null;
  }

  static Future<bool> setNewsNotiCount(int runningFirebase) {
    return _prefs.setInt("newsRunningNumber", runningFirebase);
  }

  static int getNewsNotiCount(int runningFirebase) {
    try {
      int running = _prefs.getInt("newsRunningNumber") == null ? 0 : _prefs.getInt("newsRunningNumber");

      return _calNotiCount(running, runningFirebase);
    } catch (e) {
      return 0;
    }
  }

  static Future<bool> setReportIncidentNotiCount(int runningFirebase) {
    return _prefs.setInt("reportIncidentRunningNumber", runningFirebase);
  }

  static int getReportIncidentNotiCount(int runningFirebase) {
    try {
      int running = _prefs.getInt("reportIncidentRunningNumber") == null ? 0 : _prefs.getInt("reportIncidentRunningNumber");

      return _calNotiCount(running, runningFirebase);
    } catch (e) {
      return 0;
    }
  }

  static Future<bool> setAdditionalServiceNotiCount(int runningFirebase) {
    return _prefs.setInt("additionalServiceRunningNumber", runningFirebase);
  }

  static int getAdditionalServiceNotiCount(int runningFirebase) {
    try {
      int running = _prefs.getInt("additionalServiceRunningNumber") == null ? 0 : _prefs.getInt("additionalServiceRunningNumber");

      return _calNotiCount(running, runningFirebase);
    } catch (e) {
      return 0;
    }
  }

  static Future<bool> setActivityNotiCount(int runningFirebase) {
    return _prefs.setInt("activityRunningNumber", runningFirebase);
  }

  static int getActivityNotiCount(int runningFirebase) {
    try {
      int running = _prefs.getInt("activityRunningNumber") == null ? 0 : _prefs.getInt("activityRunningNumber");

      return _calNotiCount(running, runningFirebase);
    } catch (e) {
      return 0;
    }
  }

  static Future<bool> setTimelineNotiCount(int runningFirebase) {
    return _prefs.setInt("timelineRunningNumber", runningFirebase);
  }

  static int getTimelineNotiCount(int runningFirebase) {
    try {
      int running = _prefs.getInt("timelineRunningNumber") == null ? 0 : _prefs.getInt("timelineRunningNumber");

      return _calNotiCount(running, runningFirebase);
    } catch (e) {
      return 0;
    }
  }

  static Future<bool> setNotificationCount(int runningFirebase) {
    return _prefs.setInt("notificationRunningNumber", runningFirebase);
  }

  static int getNotificationCount(int runningFirebase) {
    try {
      int running = _prefs.getInt("notificationRunningNumber") == null ? 0 : _prefs.getInt("notificationRunningNumber");

      return _calNotiCount(running, runningFirebase);
    } catch (e) {
      return 0;
    }
  }

  static Future<bool> setChatNotiCount(String key, int runningFirebase) {
    return _prefs.setInt("$key-RunningNumber", runningFirebase);
  }

  static int getChatNotiCount(String key, int runningFirebase) {
    try {
      int running = _prefs.getInt("$key-RunningNumber") == null ? 0 : _prefs.getInt("$key-RunningNumber");

      return _calNotiCount(running, runningFirebase);
    } catch (e) {
      return 0;
    }
  }

  static Future<bool> setNewRegister(bool isNewRegis) {
    return _prefs.setBool("newRegister", isNewRegis);
  }

  static bool getNewRegister() {
    try {
      return _prefs.getBool("newRegister") == null ? true : _prefs.getBool("newRegister");
    } catch (e) {
      return true;
    }
  }
  // return _prefs?.getInt(key) ?? 0;

  // try {
  //   int running = _prefs.getInt("$key-RunningNumber") == null ? 0 : _prefs.getInt("$key-RunningNumber");
  //   int count = _prefs.getInt("$key-Count") == null ? 0 : _prefs.getInt("$key-Count");
  //   if (runningNumber != 0 && running < runningNumber) {
  //     count = count + (runningNumber - running);
  //     _prefs.setInt("$key-RunningNumber", runningNumber);
  //   } else if (runningNumber != 0 && runningNumber != running) {
  //     count += 1;
  //     _prefs.setInt("$key-RunningNumber", runningNumber);
  //   }
  //   return count;
  // } catch (e) {
  //   return 0;
  // }

  // static Future<bool> setChatNotiRunningNumber(String key, int count) {
  //   return _prefs.setInt("$key-RunningNumber", count);
  // }

  static Future<bool> clear() async {
    _prefs.getKeys().map((item) {
      print(item);
      _prefs.remove(item);
    }).toList();
    _prefs.clear();

    return true;
  }

  static int _calNotiCount(int running, int runningFirebase) {
    int count = 0;
    if (runningFirebase > 0 && running > 0) {
      if (running > runningFirebase) {
        running = runningFirebase;
      }
      count = runningFirebase - running;
    } else if (runningFirebase == 0 && running > 0) {
      running = runningFirebase;
      count = runningFirebase - running;
    } else if (runningFirebase > 0 && running == 0) {
      count = runningFirebase;
    }
    return count;
  }
}
