class ExtensionFileUtil {
  //https://github.com/dart-lang/mime/blob/master/lib/src/default_extension_map.dart
  static String fromMimeType(String mimeType) {
    switch (mimeType) {
      case 'application/pdf':
        {
          return 'pdf';
        }
        break;

      case 'image/png':
        {
          return 'png';
        }
        break;

      case 'image/jpeg':
        {
          return 'jpeg';
        }
        break;
      case 'image/gif':
        {
          return 'gif';
        }
        break;
      case 'application/msword':
        {
          return 'doc';
        }
        break;
      case 'application/vnd.openxmlformats-officedocument.wordprocessingml.document':
        {
          return 'docx';
        }
        break;
      case 'application/vnd.ms-excel':
        {
          return 'xls';
        }
        break;
      case 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet':
        {
          return 'xlsx';
        }
        break;
      case 'application/vnd.ms-powerpoint':
        {
          return 'ppt';
        }
        break;
      case 'application/vnd.openxmlformats-officedocument.presentationml.presentation':
        {
          return 'pptx';
        }
        break;
      case 'text/plain':
        {
          return 'txt';
        }
        break;
      case 'audio/mpeg':
        {
          return 'mp3';
        }
        break;
      case 'application/zip':
        {
          return 'zip';
        }
        break;
      case 'application/x-rar-compressed':
        {
          return 'rar';
        }
        break;
      case 'application/vnd.oasis.opendocument.text':
        {
          return 'odt';
        }
        break;
      case 'application/rtf':
        {
          return 'rtf';
        }
        break;
      case 'application/vnd.oasis.opendocument.presentation':
        {
          return 'odp';
        }
        break;
      case 'application/vnd.oasis.opendocument.spreadsheet':
        {
          return 'ods';
        }
        break;
      case 'video/mp4':
        {
          return 'mp4';
        }
        break;
      case 'video/quicktime':
        {
          return 'mov';
        }
        break;
      case 'video/mpeg':
        {
          return 'mpeg';
        }
        break;
      case 'video/x-msvideo':
        {
          return 'avi';
        }
        break;
      case 'video/3gpp':
        {
          return '3gp';
        }
        break;
      case 'video/x-matroska':
        {
          return 'mkv';
        }
        break;
      case 'audio/x-wav':
        {
          return 'wav';
        }
        break;
      case 'audio/mpeg':
        {
          return 'mp3';
        }
        break;
      case 'image/tiff':
        {
          return 'tif';
        }
        break;
      case 'image/bmp':
        {
          return 'bmp';
        }
        break;
      case 'application/xml':
        {
          return 'xml';
        }
        break;
      case 'text/csv':
        {
          return 'csv';
        }
        break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;
      // case 'xxx':
      //   {
      //     return 'xxx';
      //   }
      //   break;

      default:
        {
          return null;
        }
        break;
    }
  }
}
