import 'package:dio/dio.dart';
import 'package:meta/meta.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/report_incident_history_model.dart';
import 'package:peasmartcare/models/report_incident_plan_model.dart';
import 'package:peasmartcare/models/report_incident_type_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';

abstract class ReportIncidentService {
  Future<ResultData> create({
    String customerId,
    String detail,
    String incidentTypeId,
    String informant,
    String customerName,
    String authenKey,
  });
  Future<ResultData> getHistoryList({String customerId, String authenKey});
  Future<ResultData> getPlanList({String customerId, String authenKey});
  Future<ResultData> getTypeList({String authenKey});
}

class ReportIncidentImpService implements ReportIncidentService {
  @override
  Future<ResultData> create({
    String customerId,
    String detail,
    String incidentTypeId,
    String informant,
    String customerName,
    @required String authenKey,
  }) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.reportIncidentCreate;

    Map<String, String> body = {
      "customerId": customerId,
      "OutageTypeId": incidentTypeId,
      "problemDetail": detail,
      "personInform": informant,
      "CustomerName": customerName,
      "authenKey": authenKey,
    };

    Response response = await dio.post(Uri.encodeFull(url), data: body);

    if (response.statusCode == 200) {
      resultData.result = response.data['statusCode'] != null ? response.data['statusCode'] == 200 : false;
    } else {
      resultData.result = false;
    }

    resultData.statusCode = response.statusCode;
    resultData.statusMessage = response.statusMessage;

    return resultData;
  }

  @override
  Future<ResultData> getHistoryList({String customerId, @required String authenKey}) async {
    List<ReportIncidentHistoryModel> resultList = List<ReportIncidentHistoryModel>();

    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.reportIncidentHistoryList;

    Map<String, String> body = {
      'customerId': customerId,
      'authenkey': authenKey,
    };

    Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

    if (response.statusCode == 200) {
      response.data.map((item) {
        ReportIncidentHistoryModel data = ReportIncidentHistoryModel.fromJson(item);
        resultList.add(data);
      }).toList();

      resultData.result = resultList;
    }

    resultData.statusCode = response.statusCode;
    resultData.statusMessage = response.statusMessage;

    return resultData;
  }

  @override
  Future<ResultData> getPlanList({String customerId, @required String authenKey}) async {
    List<ReportIncidentPlanModel> resultList = List<ReportIncidentPlanModel>();

    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.reportIncidentPlanList;

    Map<String, String> body = {
      'customerId': customerId,
      'authenkey': authenKey,
    };

    Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

    if (response.statusCode == 200) {
      response.data.map((item) {
        ReportIncidentPlanModel data = ReportIncidentPlanModel.fromJson(item);
        resultList.add(data);
      }).toList();

      resultData.result = resultList;
    }

    resultData.statusCode = response.statusCode;
    resultData.statusMessage = response.statusMessage;

    return resultData;
  }

  @override
  Future<ResultData> getTypeList({@required String authenKey}) async {
    List<ReportIncidentTypeModel> resultList = List<ReportIncidentTypeModel>();

    ResultData resultData = ResultData();
    Dio dio = Dio();

    // resultList.add(ReportIncidentTypeModel(id: "1", name: "ไฟฟ้าขัดข้อง"));
    // resultList.add(ReportIncidentTypeModel(id: "2", name: "หม้อแปลงขัดข้อง"));
    // resultList.add(ReportIncidentTypeModel(id: "3", name: "ไฟรั่ว"));

    String url = APIPath.reportIncidentTypeList;

    Map<String, String> body = {
      'authenkey': authenKey,
    };

    Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

    if (response.statusCode == 200) {
      response.data.map((item) {
        ReportIncidentTypeModel data = ReportIncidentTypeModel.fromJson(item);
        resultList.add(data);
      }).toList();

      resultData.result = resultList;
    }

    resultData.statusCode = response.statusCode;
    resultData.statusMessage = response.statusMessage;

    return resultData;
  }
}
