import 'package:dio/dio.dart';
import 'package:meta/meta.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/notification_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';

abstract class NotificationService {
  Future<ResultData> getList({String authenKey, String customerId});
}

class NotificationImpService implements NotificationService {
  @override
  Future<ResultData> getList({@required String authenKey, String customerId}) async {
    List<NotificationModel> newsList = List<NotificationModel>();

    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.notificationList;

    Map<String, String> body = {
      "customerId": customerId,
      "authenKey": authenKey,
    };

    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          NotificationModel news = NotificationModel.fromJson(item);
          newsList.add(news);
        }).toList();

        resultData.result = newsList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }
}
