import 'package:dio/dio.dart';
import 'package:meta/meta.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/news_featured_model.dart';
import 'package:peasmartcare/models/news_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';

abstract class NewsService {
  Future<ResultData> getDetail({String id, String authenKey});
  Future<ResultData> getList({String authenKey});
  Future<ResultData> getFeaturedList({String authenKey});
}

class NewsImpService implements NewsService {
  @override
  Future<ResultData> getDetail({String id, @required String authenKey}) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.newsDetail;

    Map<String, String> body = {
      "N_Id": id,
      "AuthenKey": authenKey,
    };

    try {
      Response response =
          await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        NewsModel news = NewsModel.fromJson(response.data);

        resultData.result = news;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> getList({@required String authenKey}) async {
    List<NewsModel> newsList = List<NewsModel>();

    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.newsList;

    Map<String, String> body = {
      "AuthenKey": authenKey,
    };

    print("NEWSLIST = ${url}");
    try {
      Response response =
          await dio.get(Uri.encodeFull(url), queryParameters: body);
      print("NEWSStatus = ${response.statusCode}");
      print("NEWSStatus = ${response.statusMessage}");

      if (response.statusCode == 200) {
        response.data.map((item) {
          NewsModel news = NewsModel.fromJson(item);
          newsList.add(news);
        }).toList();

        resultData.result = newsList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> getFeaturedList({@required String authenKey}) async {
    List<NewsFeaturedModel> newsList = List<NewsFeaturedModel>();

    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.newsFeaturedList;

    Map<String, String> body = {
      "AuthenKey": authenKey,
    };

    try {
      Response response =
          await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          NewsFeaturedModel news = NewsFeaturedModel.fromJson(item);
          newsList.add(news);
        }).toList();

        resultData.result = newsList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }
}
