import 'package:dio/dio.dart';
import 'package:meta/meta.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/history_bill_detail_model.dart';
import 'package:peasmartcare/models/history_bill_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';

abstract class HisstoryBillService {
  Future<ResultData> getList({String authenKey, String caNumber, String yearPayment, String monthPayment});
  Future<ResultData> getDetailList({String authenKey, String billId});
}

class HistoryBillImpService implements HisstoryBillService {
  @override
  Future<ResultData> getList({@required String authenKey, String caNumber, String yearPayment, String monthPayment}) async {
    List<HistoryBillModel> historyBillList = List<HistoryBillModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.historyBillList;
    Map<String, String> body = {
      'ca': caNumber,
      // 'YearPayment': yearPayment,
      // 'MonthPayment': monthPayment,
      "AuthenKey": authenKey,
    };
    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          HistoryBillModel historyBill = HistoryBillModel.fromJson(item);
          historyBillList.add(historyBill);
        }).toList();

        resultData.result = historyBillList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> getDetailList({@required String authenKey, String billId}) async {
    List<HistoryBillDetailModel> historyBillList = List<HistoryBillDetailModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.historyBillDetail;

    Map<String, String> body = {
      'BillID': billId,
      "AuthenKey": authenKey,
    };

    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          HistoryBillDetailModel historyBill = HistoryBillDetailModel.fromJson(item);
          historyBillList.add(historyBill);
        }).toList();

        resultData.result = historyBillList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }
}
