import 'package:dio/dio.dart';
import 'package:meta/meta.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/contact_staff_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';

abstract class ContactStaffService {
  Future<ResultData> getList({String customerId, String authenKey});
}

class ContactStaffImpService implements ContactStaffService {
  @override
  Future<ResultData> getList({String customerId, @required String authenKey}) async {
    List<ContactStaffModel> resultList = List<ContactStaffModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.contactStaffList;
    Map<String, String> body = {
      'customerId': customerId,
      "authenKey": authenKey,
    };
    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          ContactStaffModel contactStaff = ContactStaffModel.fromJson(item);
          resultList.add(contactStaff);
        }).toList();

        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }
}
