import 'package:dio/dio.dart';
import 'package:meta/meta.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/chat_message_model.dart';
import 'package:peasmartcare/models/chat_notification_model.dart';
import 'package:peasmartcare/models/chat_reader_model.dart';
import 'package:peasmartcare/models/chat_room_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';

abstract class ChatService {
  Future<ResultData> getChatList({String userId, String typeAccount, String customerId, String authenKey});
  Future<ResultData> getSingleMessageList({String userId, String typeChat, String authenKey});
  Future<ResultData> getGroupMessageList({
    String userId,
    String typeChat,
    String typeAccount,
    String chatMasterId,
    int currentPage,
    String caNumber,
    String tsic,
    String peaRegionId,
    String customerId,
    String authenKey,
  });
  Future<ResultData> sendMessage({
    String chatMasterId,
    String userId,
    String typeAccount,
    String content,
    int type,
    String authenKey,
    String fullname,
    String caNumber,
    String tsic,
    String peaRegionId,
    String customerId,
    String customerName,
    String filename,
  });

  Future<ResultData> sendChatNoti({ChatNotificationModel chatNoti});

  Future<ResultData> getChatReaderList({String messageId, String customerName, String authenKey});
}

class ChatImpService implements ChatService {
  @override
  Future<ResultData> getChatList({String userId, String typeAccount, String customerId, @required String authenKey}) async {
    List<ChatRoomModel> resultList = List<ChatRoomModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.chatList;
    Map<String, String> body = {
      'AccountId': userId,
      'TypeAccount': typeAccount,
      "customerId": customerId,
      "authenKey": authenKey,
    };
    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          ChatRoomModel result = ChatRoomModel.fromJson(item);
          resultList.add(result);
        }).toList();

        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> getSingleMessageList({String userId, String typeChat, @required String authenKey}) async {
    List<ChatMessageModel> resultList = List<ChatMessageModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.singleChatMessageList;
    Map<String, String> body = {
      'AccountId': userId,
      'TypeChat': typeChat,
      "authenKey": authenKey,
    };
    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          ChatMessageModel result = ChatMessageModel.fromJson(item);
          resultList.add(result);
        }).toList();

        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> getGroupMessageList({String userId, String typeChat, String typeAccount, String chatMasterId, int currentPage, String caNumber, String tsic, String peaRegionId, String customerId, @required String authenKey}) async {
    List<ChatMessageModel> resultList = List<ChatMessageModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.groupChatMessageList;
    Map<String, String> body = {
      'AccountId': userId,
      'TypeChat': typeChat,
      'TypeAccount': typeAccount,
      'ChatMasterId': chatMasterId,
      'currentPage': currentPage.toString(),
      "CA": caNumber,
      "TSICID": tsic,
      "BranchID": peaRegionId,
      "CustomerId": customerId,
      "authenKey": authenKey,
    };
    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          ChatMessageModel result = ChatMessageModel.fromJson(item);
          resultList.add(result);
        }).toList();

        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> sendMessage({
    String chatMasterId,
    String userId,
    String typeAccount,
    String content,
    int type,
    String fullname,
    String fileType,
    String caNumber,
    String tsic,
    String peaRegionId,
    String customerId,
    String customerName,
    String filename,
    @required String authenKey,
  }) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.sendChatMessage;
    Map<String, dynamic> body = {
      'ChatMasterId': chatMasterId,
      'AccountId': userId,
      'TypeAccount': typeAccount,
      "content": content,
      "Type": type,
      "TypeFile": fileType,
      "username": fullname,
      "CA": caNumber,
      "TSICID": tsic,
      "BranchID": peaRegionId,
      "CustomerId": customerId,
      "CustomerName": customerName,
      "FileName": filename,
      "authenKey": authenKey,
    };
    try {
      Response response = await dio.post(Uri.encodeFull(url), data: body);

      if (response.statusCode == 200) {
        resultData.result = true;
      } else {
        resultData.result = false;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> sendChatNoti({ChatNotificationModel chatNoti}) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.sendChatNoti;
    // Map<String, dynamic> body = {
    //   'ChatMasterId': chatMasterId,
    //   'AccountId': userId,
    //   'TypeAccount': typeAccount,
    //   "content": content,
    //   "Type": type,
    //   "authenKey": authenKey,
    // };

    Map<String, dynamic> body = chatNoti.toJson();
    try {
      Response response = await dio.post(Uri.encodeFull(url), data: body);

      if (response.statusCode == 200) {
        resultData.result = true;
      } else {
        resultData.result = false;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> getChatReaderList({
    String messageId,
    String customerName,
    @required String authenKey,
  }) async {
    List<ChatReaderModel> resultList = List<ChatReaderModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.chatReaderList;
    Map<String, dynamic> body = {
      'ChatId': messageId,
      "CustomerName": customerName,
      "AuthenKey": authenKey,
    };

    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          ChatReaderModel result = ChatReaderModel.fromJson(item);
          resultList.add(result);
        }).toList();

        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }
}
