import 'package:dio/dio.dart';
import 'package:meta/meta.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/additional_service_history_model.dart';
import 'package:peasmartcare/models/additional_service_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';

abstract class AdditionalService {
  Future<ResultData> getDetail({String id, String authenKey});
  Future<ResultData> getList({String customerId, String authenKey});
  Future<ResultData> getHistoryList({String caNumber, String authenKey});
  Future<ResultData> save({
    String id,
    String caNumber,
    String statusId,
    String createBy,
    String descreption,
    String customerId,
    String customerName,
    String fullname,
    String authenKey,
  });

  Future<ResultData> delete({
    String id,
    String caNumber,
    String statusId,
    String createBy,
    String descreption,
    String authenKey,
  });
}

class AdditionalImpService implements AdditionalService {
  @override
  Future<ResultData> getDetail({String id, @required String authenKey}) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.additionalServiceDetail;

    Map<String, String> body = {
      "Id": id,
      "AuthenKey": authenKey,
    };

    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        resultData.result = AdditionalServiceModel.fromJson(response.data);
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> getList({String customerId, @required String authenKey}) async {
    List<AdditionalServiceModel> resultList = List<AdditionalServiceModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.additionalServiceList;

    Map<String, String> body = {
      "customerId": customerId,
      "AuthenKey": authenKey,
    };

    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          AdditionalServiceModel result = AdditionalServiceModel.fromJson(item);
          resultList.add(result);
        }).toList();
        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> getHistoryList({String caNumber, @required String authenKey}) async {
    List<AdditionalServiceHistoryModel> resultList = List<AdditionalServiceHistoryModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.additionalServiceHistoryList;

    Map<String, String> body = {
      "CA": caNumber,
      "AuthenKey": authenKey,
    };

    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          AdditionalServiceHistoryModel result = AdditionalServiceHistoryModel.fromJson(item);
          resultList.add(result);
        }).toList();
        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> delete({
    String id,
    String caNumber,
    String statusId,
    String createBy,
    String descreption,
    @required String authenKey,
  }) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.additionalServiceDelete;

    Map<String, String> body = {
      "PR_Id": id,
      "CA": caNumber,
      "PR_StatusType": statusId,
      "CreateBy": createBy,
      "PR_Descreption": descreption,
      "AuthenKey": authenKey,
    };

    try {
      Response response = await dio.post(Uri.encodeFull(url), data: body);

      if (response.statusCode == 200) {
        resultData.result = response.data['statusCode'] == 200;
      } else {
        resultData.result = false;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }

  @override
  Future<ResultData> save({
    String id,
    String caNumber,
    String statusId,
    String createBy,
    String descreption,
    String customerId,
    String customerName,
    String fullname,
    @required String authenKey,
  }) async {
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.additionalServiceCreate;

    Map<String, String> body = {
      "P_Id": id,
      "CA": caNumber,
      "PR_StatusType": statusId,
      "CreateBy": createBy,
      "PR_Descreption": descreption,
      "CustomerId": customerId,
      "CustomerName": customerName,
      "FullName": fullname,
      "AuthenKey": authenKey,
    };

    try {
      Response response = await dio.post(Uri.encodeFull(url), data: body);

      if (response.statusCode == 200) {
        resultData.result = response.data['statusCode'] == 200;
      } else {
        resultData.result = false;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }
}
