import 'package:dio/dio.dart';
import 'package:flutter/cupertino.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/activity_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';

abstract class ActivityService {
  Future<ResultData> getList({@required String authenKey, String customerId});
}

class ActivityImpService implements ActivityService {
  @override
  Future<ResultData> getList({String authenKey, String customerId}) async {
    List<ActivityModel> resultList = List<ActivityModel>();
    ResultData resultData = ResultData();
    Dio dio = Dio();

    String url = APIPath.activityList;
    Map<String, String> body = {
      "customerId": customerId,
      "authenKey": authenKey,
    };
    try {
      Response response = await dio.get(Uri.encodeFull(url), queryParameters: body);

      if (response.statusCode == 200) {
        response.data.map((item) {
          ActivityModel result = ActivityModel.fromJson(item);
          resultList.add(result);
        }).toList();

        resultData.result = resultList;
      }

      resultData.statusCode = response.statusCode;
      resultData.statusMessage = response.statusMessage;
    } on DioError catch (e) {
      resultData.statusCode = e.response.statusCode;
      resultData.statusMessage = e.response.statusMessage;
    }

    return resultData;
  }
}
