import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:fluttericon/font_awesome_icons.dart';
import 'package:peasmartcare/blocs/timeline_list/timeline_list_bloc.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/models/timeline_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';
import 'package:peasmartcare/widgets/timeline.dart';

class TimelineList extends StatefulWidget {
  @override
  _TimelineListState createState() => _TimelineListState();
}

class _TimelineListState extends State<TimelineList> {
  @override
  Future<void> initState() {
    context.read<TimelineListBloc>().add(TimelineListGetList());

    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<TimelineListBloc, TimelineListState>(
      listener: (context, state) {
        if (state is TimelineListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<TimelineListBloc, TimelineListState>(
        builder: (context, state) {
          if (state is TimelineListLoading) {
            return Loading();
          } else if (state is TimelineListLoaded) {
            List<TimelineModel> resultList = state.result;
            return _buildTimeLine(resultList);
            // return Column(
            //   children: resultList.map((item) {
            //     return _buildTimeLine(
            //       dateTime: item.dateTime,
            //       type: item.type,
            //       detail: item.detail,
            //     );
            //   }).toList(),
            // );
          } else if (state is TimelineListNotFound) {
            return NotFoundBox();
          } else if (state is TimelineListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTimeLine(List<TimelineModel> timelineList) {
    Size deviceSize = MediaQuery.of(context).size;
    Color color = Color(AppData.blueColor);
    timelineList = timelineList == null ? [] : timelineList;
    return Container(
      // height: (timelineList.length * 150.0) - ((timelineList.length * 150.0) > deviceSize.height ? timelineList.length * 15 : 0),
      child: Timeline(
        children: timelineList.map((item) {
          return _buildTable(
            dateTime: item.dateTime,
            detail: item.detail,
            type: item.type,
          );
        }).toList(),
        detailLength: timelineList.map((item) {
          return (item.detail).length;
        }).toList(),
        indicators: timelineList.map((item) {
          return Icon(
            FontAwesome.circle_empty,
            color: Color(AppData.purpleColor),
          );
        }).toList(),
        lineColor: Color(AppData.yellowColor),
      ),
    );
  }

  Widget _buildTable({String dateTime, String type, String detail}) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      padding: const EdgeInsets.all(5),
      child: Card(
        elevation: 3,
        child: Container(
          padding: EdgeInsets.all(15),
          width: deviceSize.width - 40,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                type ?? "",
                style: TextStyle(fontWeight: FontWeight.bold, fontSize: 17),
              ),
              Table(
                columnWidths: {0: FixedColumnWidth(80)},
                children: [
                  // TableRow(
                  //   children: [
                  //     TableCell(
                  //       child: Text(""),
                  //     ),
                  //     TableCell(
                  //       child: Text(
                  //         type ?? "",
                  //         style: TextStyle(fontWeight: FontWeight.bold),
                  //       ),
                  //     ),
                  //   ],
                  // ),
                  TableRow(
                    children: [
                      TableCell(
                        child: Text("วันที่"),
                      ),
                      TableCell(
                        child: Text(dateTime ?? ""),
                      ),
                    ],
                  ),
                  TableRow(
                    children: [
                      TableCell(
                        child: Text("รายละเอียด"),
                      ),
                      TableCell(
                        child: Text(detail ?? ""),
                      ),
                    ],
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
