import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/survey_list/survey_list_bloc.dart';
import 'package:peasmartcare/models/survey_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/pages/survey/survey_question_edit.dart';
import 'package:peasmartcare/utils/share_data_util.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';
import 'package:peasmartcare/widgets/sweetalert/sweetalert.dart';

class SurveyList extends StatefulWidget {
  final String surveyName;

  const SurveyList({Key key, this.surveyName}) : super(key: key);
  @override
  _SurveyListState createState() => _SurveyListState();
}

class _SurveyListState extends State<SurveyList> {
  @override
  void initState() {
    context.read<SurveyListBloc>().add(SurveyListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<SurveyListBloc, SurveyListState>(
      listener: (context, state) {
        if (state is SurveyListLoaded) {
          if (state.deleteSuccess != null && state.deleteSuccess) {
            context.read<SurveyListBloc>().add(SurveyListGetList());
            SweetAlert.show(
              context,
              subtitle: "ลบข้อมูลสำเร็จ",
              style: SweetAlertStyle.success,
              onPress: (bool isConfirm) {
                if (isConfirm) {
                  Navigator.pop(context);

                  return false;
                }
              },
            );
          } else if (state.deleteSuccess != null && !state.deleteSuccess) {
            SweetAlert.show(
              context,
              subtitle: "ลบข้อมูลไม่สำเร็จ",
              style: SweetAlertStyle.error,
            );
          }
        } else if (state is SurveyListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<SurveyListBloc, SurveyListState>(
        builder: (context, state) {
          if (state is SurveyListLoading) {
            return Loading();
          } else if (state is SurveyListLoaded) {
            List<SurveyModel> resultList = state.result;
            return Column(
              children: resultList.map((item) {
                return _buildTable(item);
              }).toList(),
            );
          } else if (state is SurveyListNotFound) {
            return NotFoundBox();
          } else if (state is SurveyListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTable(SurveyModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      padding: const EdgeInsets.all(5),
      child: Card(
        elevation: 3,
        child: Container(
          padding: EdgeInsets.all(15),
          width: deviceSize.width - 40,
          child: Table(
            columnWidths: {1: FixedColumnWidth(40)},
            defaultVerticalAlignment: TableCellVerticalAlignment.middle,
            children: [
              TableRow(
                children: [
                  TableCell(
                    child: Table(
                      columnWidths: {0: FixedColumnWidth(80)},
                      defaultVerticalAlignment: TableCellVerticalAlignment.middle,
                      children: [
                        TableRow(
                          children: [
                            TableCell(
                              child: Text("ผู้ตอบ"),
                            ),
                            TableCell(
                              child: Text(item.createBy),
                            ),
                          ],
                        ),
                        TableRow(
                          children: [
                            TableCell(
                              child: Text("เลขที่"),
                            ),
                            TableCell(
                              child: Text(item.srcqSequence),
                            ),
                          ],
                        ),

                        TableRow(
                          children: [
                            TableCell(
                              child: Text("วันที่"),
                            ),
                            TableCell(
                              child: Text(item.createDate),
                            ),
                          ],
                        ),

                        // TableRow(
                        //   children: [
                        //     TableCell(
                        //       child: Text("วันที่สิ้นสุด"),
                        //     ),
                        //     TableCell(
                        //       child: Text(item.endDate),
                        //     ),
                        //   ],
                        // ),
                      ],
                    ),
                  ),
                  TableCell(
                    verticalAlignment: TableCellVerticalAlignment.middle,
                    child: Column(
                      children: [
                        Padding(
                          padding: const EdgeInsets.only(left: 10),
                          child: InkWell(
                            child: Icon(
                              Icons.edit,
                              color: Colors.blue,
                            ),
                            onTap: () {
                              Navigator.push(
                                context,
                                MaterialPageRoute(
                                    builder: (context) => SurveyQuestionEdit(
                                          surveyId: item.id,
                                          surveyName: widget.surveyName,
                                          srcqId: item.srcqId,
                                          customerId: ShareDataUtil.getCustomerId(),
                                          fullname: ShareDataUtil.getFullname(),
                                        )),
                              );
                            },
                          ),
                        ),
                        SizedBox(height: 20),
                        Padding(
                          padding: const EdgeInsets.only(left: 10),
                          child: InkWell(
                            child: Icon(
                              Icons.delete,
                              color: Colors.red,
                            ),
                            onTap: () {
                              SweetAlert.show(
                                context,
                                title: "ต้องการลบข้อมูลใช่หรือไม่",
                                style: SweetAlertStyle.confirm,
                                showCancelButton: true,
                                onPress: (bool isConfirm) {
                                  if (isConfirm) {
                                    context.read<SurveyListBloc>().add(
                                          SurveyListOnDelete(srcqId: item.srcqId),
                                        );
                                    Navigator.pop(context);
                                    return false;
                                  }
                                },
                              );
                            },
                          ),
                        ),
                      ],
                    ),
                  )
                ],
              ),
            ],
          ),
        ),
      ),
    );
    // return InkWell(
    //   child: Container(
    //     padding: const EdgeInsets.all(5),
    //     child: Card(
    //       elevation: 3,
    //       child: Container(
    //         padding: EdgeInsets.all(15),
    //         width: deviceSize.width - 40,
    //         child: Table(
    //           columnWidths: {0: FixedColumnWidth(80)},
    //           children: [
    //             TableRow(
    //               children: [
    //                 TableCell(
    //                   child: Text("เรื่องสำรวจ"),
    //                 ),
    //                 TableCell(
    //                   child: Text(item.createBy),
    //                 ),
    //               ],
    //             ),
    //             TableRow(
    //               children: [
    //                 TableCell(
    //                   child: Text("วันที่เริ่มต้น"),
    //                 ),
    //                 TableCell(
    //                   child: Text(item.createDate),
    //                 ),
    //               ],
    //             ),
    //             // TableRow(
    //             //   children: [
    //             //     TableCell(
    //             //       child: Text("วันที่สิ้นสุด"),
    //             //     ),
    //             //     TableCell(
    //             //       child: Text(item.endDate),
    //             //     ),
    //             //   ],
    //             // ),
    //           ],
    //         ),
    //       ),
    //     ),
    //   ),
    //   onTap: () {
    //     context.read<SurveyQuestionBloc>().add(SurveyQuestionAddSurveyId(
    //           surveyId: item.id,
    //         ));
    //     Navigator.push(
    //       context,
    //       MaterialPageRoute(
    //           builder: (context) => SurveyQuestion(
    //                 surveyName: widget.surveyName,//item.subject,
    //               )),
    //     );
    //   },
    // );
  }
}
