import 'package:flutter/material.dart';
import 'package:grouped_buttons/grouped_buttons.dart';
import 'package:peasmartcare/blocs/survey_question/survey_question_bloc.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/models/survey_answer_model.dart';
import 'package:peasmartcare/models/survey_choice_model.dart';
import 'package:peasmartcare/widgets/empty_box.dart';

class SurveyChoiceRadio extends StatefulWidget {
  final List<SurveyChoiceModel> surveyChoiceList;
  final SurveyQuestionBloc bloc;
  final String questionName;
  final int currentIndex;
  final String surveyId;
  final bool isNext;
  final String customerId;
  final bool isValidate;
  final String defaultVelue;

  const SurveyChoiceRadio({
    Key key,
    @required this.bloc,
    @required this.questionName,
    @required this.surveyChoiceList,
    @required this.currentIndex,
    @required this.surveyId,
    @required this.isNext,
    @required this.customerId,
    this.isValidate = false,
    this.defaultVelue,
  }) : super(key: key);

  @override
  _SurveyChoiceRadioState createState() => _SurveyChoiceRadioState();
}

class _SurveyChoiceRadioState extends State<SurveyChoiceRadio> {
  final _formKey = GlobalKey<FormState>();

  TextStyle textStyle = TextStyle(color: Color(AppData.primaryColor), fontSize: 18);
  TextStyle errortyle = TextStyle(color: Colors.red[900], fontSize: 18);
  bool isError = false;
  String _selectedShow;
  List<SurveyChoiceModel> _selectedResult = List<SurveyChoiceModel>();

  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      child: Column(
        children: <Widget>[
          SizedBox(height: 5),
          Form(
            key: _formKey,
            child: Card(
              shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.circular(20),
              ),
              color: Colors.purple[50],
              child: RadioButtonGroup(
                orientation: GroupedButtonsOrientation.VERTICAL,
                activeColor: Color(AppData.yellowColor),
                labelStyle: TextStyle(color: Color(AppData.purpleColor)),
                margin: const EdgeInsets.only(left: 12.0),
                onSelected: (String selected) => setState(() {
                  _selectedResult = List<SurveyChoiceModel>();
                  _selectedShow = selected;
                  SurveyChoiceModel qtObj = widget.surveyChoiceList.singleWhere(
                    (qt) => _selectedShow == qt.name,
                    orElse: () => null,
                  );

                  _selectedResult.add(qtObj);
                }),
                labels: widget.surveyChoiceList.map((item) {
                  return item.name;
                }).toList(),
                picked: _selectedShow,
                itemBuilder: (Radio rb, Text txt, int i) {
                  return Row(
                    children: <Widget>[
                      rb,
                      txt,
                    ],
                  );
                },
              ),
            ),
          ),
          isError
              ? Align(
                  alignment: Alignment.topLeft,
                  child: Container(
                      padding: EdgeInsets.only(left: 10),
                      height: 30,
                      child: Text(
                        "กรุณาเลือกรายการ",
                        style: errortyle,
                      )),
                )
              : EmptyBox(),
          Row(
            crossAxisAlignment: CrossAxisAlignment.end,
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Container(
                padding: EdgeInsets.fromLTRB(0, 30, 0, 15),
                child: RaisedButton(
                  padding: EdgeInsets.only(top: 12, left: 30, right: 30, bottom: 12),
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(7),
                  ),
                  child: Text(
                    widget.isNext ? "ถัดไป" : "ส่งแบบสำรวจ",
                    style: TextStyle(
                      fontWeight: FontWeight.w800,
                      color: Colors.white,
                      fontSize: 18,
                    ),
                  ),
                  color: Color(AppData.yellowColor),
                  onPressed: () {
                    bool _isValidate = widget.isValidate ? _selectedResult.length > 0 : true;
                    if (_isValidate) {
                      
                      if (widget.surveyChoiceList.length > 0) {
                        setState(() {
                          isError = false;
                        });
                        _selectedResult.map((item) {
                          SurveyAnswerModel answer = SurveyAnswerModel();
                          answer.questionId = item.questionId;
                          answer.choiceId = item.id;
                          answer.value = item.id;
                          answer.customerId = widget.customerId;
                          widget.bloc.add(SurveyQuestionAddAnswer(
                            answer: answer,
                          ));

                          widget.bloc.add(SurveyQuestionGetCurrentQuestion(
                            currentIndex: widget.currentIndex + 1,
                          ));
                        }).toList();

                        if (!widget.isNext) {
                          widget.bloc.add(SurveyQuestionSendAnswer());
                        }
                      } else {
                        setState(() {
                          isError = true;
                        });
                      }
                    } else {
                      setState(() {
                        isError = true;
                      });
                    }
                  },
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
