import 'package:flutter/material.dart';
import 'package:peasmartcare/blocs/survey_question/survey_question_bloc.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/models/survey_answer_model.dart';
import 'package:peasmartcare/models/survey_choice_model.dart';

class SurveyChoiceDropdown extends StatefulWidget {
  final List<SurveyChoiceModel> surveyChoiceList;
  final SurveyQuestionBloc bloc;
  final String questionName;
  final int currentIndex;
  final String surveyId;
  final bool isNext;
  final String customerId;
  final bool isValidate;
  final String defaultVelue;

  const SurveyChoiceDropdown({
    Key key,
    @required this.bloc,
    @required this.questionName,
    @required this.surveyChoiceList,
    @required this.currentIndex,
    @required this.surveyId,
    @required this.isNext,
    @required this.customerId,
    this.isValidate = false,
    this.defaultVelue,
  }) : super(key: key);

  @override
  _SurveyChoiceDropdownState createState() => _SurveyChoiceDropdownState();
}

class _SurveyChoiceDropdownState extends State<SurveyChoiceDropdown> {
  final _formKey = GlobalKey<FormState>();
  SurveyChoiceModel _survey = SurveyChoiceModel();
  TextStyle textStyle = TextStyle(color: Color(AppData.primaryColor), fontSize: 18);
  TextStyle errortyle = TextStyle(color: Colors.red[900], fontSize: 18);

  String _dropdownValue;
  String _dropdownName;

  @override
  void initState() {
    widget.surveyChoiceList.insert(0, SurveyChoiceModel(id: "", name: "เลือก${widget.questionName}", questionId: ""));
    // if (widget.surveyChoiceList.length > 0) {
    //   _survey = widget.surveyChoiceList[0];
    // }
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      width: double.infinity,
      child: Column(
        children: <Widget>[
          SizedBox(height: 5),
          Form(
            key: _formKey,
            child: Container(
              padding: EdgeInsets.fromLTRB(20, 5, 20, 5),
              margin: EdgeInsets.fromLTRB(5, 5, 5, 5),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(20),
                color: Color(AppData.whiteColor),
              ),
              child: DropdownButtonFormField<dynamic>(
                validator: (value) {
                  if (widget.isValidate && (value == null || value.isEmpty)) {
                    return "กรุณาเลือก ${widget.questionName}";
                  }
                  return null;
                },
                value: _dropdownValue,
                hint: Text(
                  "เลือก${widget.questionName}",
                  style: TextStyle(color: Color(AppData.greyColor)),
                ),
                icon: Icon(Icons.keyboard_arrow_down),
                isExpanded: true,
                onChanged: (val) {
                  setState(() {
                    _dropdownValue = val;
                  });

                  // ElectricityStatisticTypeModel type = typeList.singleWhere((item) => item.value == val);

                  setState(() {
                    _dropdownValue = val;
                    // _dropdownName = type.name;
                  });
                },
                decoration: InputDecoration(
                  enabledBorder: InputBorder.none,
                ),
                items: widget.surveyChoiceList.map<DropdownMenuItem<dynamic>>(
                  (value) {
                    return DropdownMenuItem<dynamic>(
                      value: value.id ?? '',
                      child: Text(value.name ?? ''),
                    );
                  },
                ).toList(),
                selectedItemBuilder: (BuildContext context) {
                  return widget.surveyChoiceList.map<Widget>((item) {
                    return Text(item.name ?? '');
                  }).toList();
                },
              ),
            ),
          ),
          Row(
            crossAxisAlignment: CrossAxisAlignment.end,
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Container(
                padding: EdgeInsets.fromLTRB(0, 30, 0, 15),
                child: RaisedButton(
                  padding: EdgeInsets.only(top: 12, left: 30, right: 30, bottom: 12),
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(7),
                  ),
                  child: Text(
                    widget.isNext ? "ถัดไป" : "ส่งแบบสำรวจ",
                    style: TextStyle(
                      fontWeight: FontWeight.w800,
                      color: Colors.white,
                      fontSize: 18,
                    ),
                  ),
                  color: Color(AppData.yellowColor),
                  onPressed: () {
                    if (_formKey.currentState.validate()) {
                      SurveyAnswerModel answer = SurveyAnswerModel();
                      if (widget.surveyChoiceList.length > 0) {
                        answer.questionId = _survey.questionId;
                        answer.choiceId = _survey.id;
                        answer.value = _dropdownValue;
                        answer.customerId = widget.customerId;

                        widget.bloc.add(SurveyQuestionAddAnswer(
                          answer: answer,
                        ));

                        widget.bloc.add(SurveyQuestionGetCurrentQuestion(
                          currentIndex: widget.currentIndex + 1,
                        ));

                        if (!widget.isNext) {
                          widget.bloc.add(SurveyQuestionSendAnswer());
                        }
                      }
                    }
                  },
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
