import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_slidable/flutter_slidable.dart';
import 'package:peasmartcare/blocs/report_incident_plan_list/report_incident_plan_list_bloc.dart';
import 'package:peasmartcare/models/report_incident_plan_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/utils/app_util.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';
import 'package:peasmartcare/widgets/sweetalert/sweetalert.dart';

class ReportIncidentPlanList extends StatefulWidget {
  @override
  _ReportIncidentPlanListState createState() => _ReportIncidentPlanListState();
}

class _ReportIncidentPlanListState extends State<ReportIncidentPlanList> {
  @override
  void initState() {
    context.read<ReportIncidentPlanListBloc>().add(ReportIncidentPlanListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<ReportIncidentPlanListBloc, ReportIncidentPlanListState>(
      listener: (context, state) {
        if (state is ReportIncidentPlanListLoaded) {
          if (state.deleteSuccess != null && state.deleteSuccess) {
            SweetAlert.show(
              context,
              subtitle: "ลบข้อมูลสำเร็จ",
              style: SweetAlertStyle.success,
            );

            context.read<ReportIncidentPlanListBloc>().add(ReportIncidentPlanListGetList());
          } else if (state.deleteSuccess != null && !state.deleteSuccess) {
            SweetAlert.show(
              context,
              subtitle: "ลบข้อมูลไม่สำเร็จ",
              style: SweetAlertStyle.error,
            );
          }
        } else if (state is ReportIncidentPlanListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<ReportIncidentPlanListBloc, ReportIncidentPlanListState>(
        builder: (context, state) {
          if (state is ReportIncidentPlanListLoading) {
            return Loading();
          } else if (state is ReportIncidentPlanListLoaded) {
            List<ReportIncidentPlanModel> resultList = state.result;
            return Column(
              children: resultList.map((item) {
                return Slidable(
                  enabled: false,
                  actionPane: SlidableBehindActionPane(),
                  actionExtentRatio: 0.25,
                  child: _buildTable(item),
                  secondaryActions: <Widget>[
                    Container(
                      padding: EdgeInsets.only(top: 5, bottom: 5),
                      child: Card(
                        child: IconSlideAction(
                          color: Colors.red,
                          icon: Icons.delete,
                          onTap: () {
                            print("Delete");
                          },
                        ),
                      ),
                    ),
                  ],
                );
              }).toList(),
            );
          } else if (state is ReportIncidentPlanListNotFound) {
            return NotFoundBox();
          } else if (state is ReportIncidentPlanListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTable(ReportIncidentPlanModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      padding: const EdgeInsets.all(5),
      child: Card(
        elevation: 3,
        child: Container(
          padding: EdgeInsets.all(15),
          width: deviceSize.width - 40,
          child: Table(
            columnWidths: {0: FixedColumnWidth(80)},
            children: [
              TableRow(
                children: [
                  TableCell(
                    child: Text("ตั้งแต่วันที่"),
                  ),
                  TableCell(
                    child: Text(item.startDate),
                  ),
                ],
              ),
              TableRow(
                children: [
                  TableCell(
                    child: Text("ถึงวันที่"),
                  ),
                  TableCell(
                    child: Text(AppUtil.isNil(item.endDate) ? "-" : item.endDate),
                  ),
                ],
              ),
              TableRow(
                children: [
                  TableCell(
                    child: Text("รายละเอียด"),
                  ),
                  TableCell(
                    child: Text(item.detail),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
