import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/report_incident_history_list/report_incident_history_list_bloc.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/header_content.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/pea_bottom_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/components/customer_info.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/report_incident/report_incident_history_list.dart';
import 'package:peasmartcare/pages/report_incident/report_incident_menu.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class ReportIncidentHistoryPage extends StatefulWidget {
  @override
  _ReportIncidentHistoryPageState createState() => _ReportIncidentHistoryPageState();
}

class _ReportIncidentHistoryPageState extends State<ReportIncidentHistoryPage> {
  RefreshController _refreshController = RefreshController(initialRefresh: false);

  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Scaffold(
      appBar: PEAAppBar(
        title: "ประวัติไฟฟ้าขัดข้อง",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      bottomNavigationBar: PEABottomBar(),
      body: BodyLayout(
        header: CustomerInfo(),
        onPullRefresh: _onRefresh,
        refreshController: _refreshController,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "ประวัติไฟฟ้าขัดข้อง",
                  icon: ImageAsset.reportIncidentImg,
                ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 70),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            ReportIncidentMenu(activeIndex: 1),
            ReportIncidentHistoryList(),
          ],
        ),
      ),
    );
  }

  Future<void> _onRefresh() async {
    context.read<ReportIncidentHistoryListBloc>().add(ReportIncidentHistoryListGetList());

    await Future.delayed(Duration(milliseconds: 1000));
    _refreshController.refreshCompleted();
  }
}
