import 'package:flutter/material.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/header_content.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/pea_bottom_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/components/customer_info.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/report_incident/report_incident_form.dart';
import 'package:peasmartcare/pages/report_incident/report_incident_menu.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class ReportIncidentPage extends StatefulWidget {
  @override
  _ReportIncidentPageState createState() => _ReportIncidentPageState();
}

class _ReportIncidentPageState extends State<ReportIncidentPage> {
  RefreshController _refreshController = RefreshController(initialRefresh: false);
  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Scaffold(
      appBar: PEAAppBar(
        title: "แจ้งเหตุไฟฟ้าขัดข้อง",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      bottomNavigationBar: PEABottomBar(),
      body: BodyLayout(
        header: CustomerInfo(),
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "แจ้งเหตุไฟฟ้าขัดข้อง",
                  icon: ImageAsset.reportIncidentImg,
                ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 70),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            ReportIncidentMenu(),
            ReportIncidentForm(),
          ],
        ),
      ),
    );
  }
}
