import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/questionnaire_question/questionnaire_question_bloc.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/constraints/api_path.dart';
import 'package:peasmartcare/models/questionnaire_question_model.dart';
import 'package:peasmartcare/pages/questionnaire/questionnaire_choice/questionnaire_choice_checkbox.dart';
import 'package:peasmartcare/pages/questionnaire/questionnaire_choice/questionnaire_choice_multi_radio.dart';
import 'package:peasmartcare/pages/questionnaire/questionnaire_choice/questionnaire_choice_radio.dart';
import 'package:peasmartcare/pages/questionnaire/questionnaire_choice/questionnaire_choice_text.dart';
import 'package:peasmartcare/utils/share_data_util.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/sweetalert/sweetalert.dart';
import 'package:webview_flutter_plus/webview_flutter_plus.dart';

class QuestionnaireQuestion extends StatefulWidget {
  final String questionnaireId;
  final String questionnaireName;
  final String customerId;
  final String fullname;

  const QuestionnaireQuestion({
    Key key,
    @required this.questionnaireId,
    @required this.questionnaireName,
    @required this.customerId,
    @required this.fullname,
  }) : super(key: key);
  @override
  _QuestionnaireQuestionState createState() => _QuestionnaireQuestionState();
}

class _QuestionnaireQuestionState extends State<QuestionnaireQuestion> {
  WebViewPlusController _webViewController;
  String urlPath;
  String urlSuccessPath;
  String urlUnsuccessPath;
  int _currentIndex = 0;

  @override
  void initState() {
    context.read<QuestionnaireQuestionBloc>().add(QuestionnaireQuestionGetList());
    urlPath = "${APIPath.questionnaireQuestionWebView}?id=${widget.questionnaireId}&customerId=${widget.customerId}&username=${widget.fullname}&AuthenKey=${ShareDataUtil.getAuthenKey()}";
    urlSuccessPath = APIPath.questionnaireQuestionSendSuccessWebView;
    urlUnsuccessPath = APIPath.questionnaireQuestionSendUnsuccessWebView;
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: PEAAppBar(
        title: "ตอบแบบสอบถาม",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      body: _buildItem(),
    );
  }

  Widget _buildItem() {
    Size deviceSize = MediaQuery.of(context).size;

    return Container(
      // height: _webViewHeight == 0 ? deviceSize.height : _webViewHeight,
      height: deviceSize.height,
      child: WebViewPlus(
        javascriptMode: JavascriptMode.unrestricted,
        onWebViewCreated: (controller) {
          this._webViewController = controller;
          controller.loadUrl(Uri.encodeFull(urlPath));
        },
        onPageFinished: (url) {
          _webViewController.getHeight().then((double height) {
            // setState(() {
            //   _webViewHeight = height;
            // });
          });

          if (!url.contains(urlPath)) {
            if (url.contains(urlSuccessPath) || url.contains("$urlSuccessPath/")) {
              SweetAlert.show(
                context,
                subtitle: "ส่งแบบสอบถามสำเร็จ",
                style: SweetAlertStyle.success,
                showCancelButton: false,
                onPress: (bool isConfirm) {
                  if (isConfirm) {
                    Navigator.pop(context);
                    Navigator.pop(context);
                    return false;
                  }
                },
              );
            } else if (url.contains(urlUnsuccessPath) || url.contains("$urlUnsuccessPath/")) {
              SweetAlert.show(
                context,
                subtitle: "ส่งแบบสอบถามไม่สำเร็จ",
                style: SweetAlertStyle.error,
                showCancelButton: false,
                onPress: (bool isConfirm) {
                  if (isConfirm) {
                    Navigator.pop(context);
                    Navigator.pop(context);
                    return false;
                  }
                },
              );
            }
          }
        },
      ),
    );
  }

  Widget _buildChoice(QuestionnaireQuestionModel question, bool isNext, String customerId) {
    return (() {
      switch (question.type) {
        case 1:
          {
            return QuestionnaireChoiceRadio(
              questionnaireId: question.id,
              bloc: context.read<QuestionnaireQuestionBloc>(),
              questionnaireChoiceList: question.choiceList,
              currentIndex: _currentIndex,
              isNext: isNext,
              customerId: customerId,
            );
          }
          break;
        case 2:
          {
            return QuestionnaireChoiceCheckbox(
              questionnaireId: question.id,
              bloc: context.read<QuestionnaireQuestionBloc>(),
              questionnaireChoiceList: question.choiceList,
              currentIndex: _currentIndex,
              isNext: isNext,
              customerId: customerId,
            );
          }
          break;
        case 3:
          {
            return QuestionnaireChoiceMultiRadio(
              questionnaireId: question.id,
              bloc: context.read<QuestionnaireQuestionBloc>(),
              questionnaireChoiceList: question.choiceList,
              currentIndex: _currentIndex,
              isNext: isNext,
              customerId: customerId,
            );
          }
          break;
        case 4:
          {
            return QuestionnaireChoiceText(
              questionnaireId: question.id,
              bloc: context.read<QuestionnaireQuestionBloc>(),
              questionnaireChoiceList: question.choiceList,
              currentIndex: _currentIndex,
              isNext: isNext,
              customerId: customerId,
            );
          }
          break;
        default:
          {
            return EmptyBox();
          }
          break;
      }
    }());
  }
}
