import 'package:flutter/material.dart';
import 'package:grouped_buttons/grouped_buttons.dart';
import 'package:peasmartcare/blocs/questionnaire_question/questionnaire_question_bloc.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/models/questionnaire_answer_model.dart';
import 'package:peasmartcare/models/questionnaire_choice_model.dart';

class QuestionnaireChoiceRadio extends StatefulWidget {
  final List<QuestionnaireChoiceModel> questionnaireChoiceList;
  final QuestionnaireQuestionBloc bloc;
  final int currentIndex;
  final String questionnaireId;
  final bool isNext;
  final String customerId;

  const QuestionnaireChoiceRadio({
    Key key,
    @required this.questionnaireChoiceList,
    @required this.bloc,
    @required this.currentIndex,
    @required this.questionnaireId,
    @required this.isNext,
    @required this.customerId,
  }) : super(key: key);

  @override
  _QuestionnaireChoiceRadioState createState() => _QuestionnaireChoiceRadioState();
}

class _QuestionnaireChoiceRadioState extends State<QuestionnaireChoiceRadio> {
  String _selectedShow;
  List<QuestionnaireChoiceModel> _selectedResult = List<QuestionnaireChoiceModel>();
  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      // height: widget.questionnaireChoiceList.length * 80.0,
      width: double.infinity,
      child: Column(
        children: <Widget>[
          Card(
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.circular(20),
            ),
            color: Colors.purple[50],
            child: RadioButtonGroup(
              orientation: GroupedButtonsOrientation.VERTICAL,
              activeColor: Color(AppData.yellowColor),
              labelStyle: TextStyle(color: Color(AppData.purpleColor)),
              margin: const EdgeInsets.only(left: 12.0),
              onSelected: (String selected) => setState(() {
                _selectedResult = List<QuestionnaireChoiceModel>();
                _selectedShow = selected;
                QuestionnaireChoiceModel qtObj = widget.questionnaireChoiceList.singleWhere(
                  (qt) => _selectedShow == qt.name,
                  orElse: () => null,
                );

                _selectedResult.add(qtObj);
              }),
              labels: widget.questionnaireChoiceList.map((item) {
                return item.name;
              }).toList(),
              picked: _selectedShow,
              itemBuilder: (Radio rb, Text txt, int i) {
                return Row(
                  children: <Widget>[
                    rb,
                    txt,
                  ],
                );
              },
            ),
          ),
          Row(
            crossAxisAlignment: CrossAxisAlignment.end,
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Container(
                padding: EdgeInsets.fromLTRB(0, 30, 0, 15),
                child: RaisedButton(
                  padding: EdgeInsets.only(top: 12, left: 30, right: 30, bottom: 12),
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(7),
                  ),
                  child: Text(
                    widget.isNext ? "ถัดไป" : "ส่งแบบสอบถาม",
                    style: TextStyle(
                      fontWeight: FontWeight.w800,
                      color: Colors.white,
                      fontSize: 18,
                    ),
                  ),
                  color: Color(AppData.yellowColor),
                  onPressed: () {
                    _selectedResult.map((item) {
                      QuestionnaireAnswerModel answer = QuestionnaireAnswerModel();
                      answer.questionId = item.questionId;
                      answer.choiceId = item.id;
                      answer.value = item.id;
                      answer.customerId = widget.customerId;

                      widget.bloc.add(QuestionnaireQuestionAddAnswer(
                        answer: answer,
                      ));
                      widget.bloc.add(QuestionnaireQuestionGetCurrentQuestion(
                        currentIndex: widget.currentIndex + 1,
                      ));
                    }).toList();

                    if (!widget.isNext) {
                      widget.bloc.add(QuestionnaireQuestionSendAnswer());
                    }
                  },
                ),
              ),
            ],
          ),
          
        ],
      ),
    );
  }
}
