import 'package:flutter/material.dart';
import 'package:group_radio_button/group_radio_button.dart';
import 'package:peasmartcare/blocs/questionnaire_question/questionnaire_question_bloc.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/models/questionnaire_answer_model.dart';
import 'package:peasmartcare/models/questionnaire_choice_model.dart';
import 'package:peasmartcare/widgets/empty_box.dart';

class QuestionnaireChoiceMultiRadio extends StatefulWidget {
  final List<QuestionnaireChoiceModel> questionnaireChoiceList;
  final QuestionnaireQuestionBloc bloc;
  final int currentIndex;
  final String questionnaireId;
  final bool isNext;
  final String customerId;

  const QuestionnaireChoiceMultiRadio({
    Key key,
    @required this.questionnaireChoiceList,
    @required this.bloc,
    @required this.currentIndex,
    @required this.questionnaireId,
    @required this.isNext,
    @required this.customerId,
  }) : super(key: key);

  @override
  _QuestionnaireChoiceMultiRadioState createState() => _QuestionnaireChoiceMultiRadioState();
}

class _QuestionnaireChoiceMultiRadioState extends State<QuestionnaireChoiceMultiRadio> {
  List<QuestionnaireAnswerModel> _selectedResult;
  List<String> _selectedValue;
  List<String> _valueList = ["1", "2", "3", "4", "5"];

  @override
  void initState() {
    _selectedValue = List(widget.questionnaireChoiceList.length);
    _selectedResult = List(widget.questionnaireChoiceList.length);
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      child: Column(
        children: <Widget>[
          Column(
            children: widget.questionnaireChoiceList
                .asMap()
                .map((index, item) => MapEntry(
                      index,
                      _buildMultiRadio(index, item),
                    ))
                .values
                .toList(),
          ),
          Row(
            crossAxisAlignment: CrossAxisAlignment.end,
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Container(
                padding: EdgeInsets.fromLTRB(0, 30, 0, 15),
                child: RaisedButton(
                  padding: EdgeInsets.only(top: 12, left: 30, right: 30, bottom: 12),
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(7),
                  ),
                  child: Text(
                    widget.isNext ? "ถัดไป" : "ส่งแบบสอบถาม",
                    style: TextStyle(
                      fontWeight: FontWeight.w800,
                      color: Colors.white,
                      fontSize: 18,
                    ),
                  ),
                  color: Color(AppData.yellowColor),
                  onPressed: () {
                    _selectedResult.map((item) {
                      QuestionnaireAnswerModel answer = QuestionnaireAnswerModel();
                      answer.questionId = item.questionId;
                      answer.choiceId = item.choiceId;
                      answer.customerId = widget.customerId;
                      answer.value = item.value;

                      widget.bloc.add(QuestionnaireQuestionAddAnswer(
                        answer: answer,
                      ));
                      widget.bloc.add(QuestionnaireQuestionGetCurrentQuestion(
                        currentIndex: widget.currentIndex + 1,
                      ));
                    }).toList();

                    if (!widget.isNext) {
                      widget.bloc.add(QuestionnaireQuestionSendAnswer());
                    }
                  },
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }

  Widget _buildMultiRadio(int index, QuestionnaireChoiceModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return Card(
      shape: RoundedRectangleBorder(
        borderRadius: BorderRadius.circular(20),
      ),
      color: Colors.purple[50],
      child: Container(
        padding: EdgeInsets.all(8),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            (index == 0)
                ? Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      Text("น้อยที่สุด", textAlign: TextAlign.center),
                      Text("น้อย", textAlign: TextAlign.center),
                      Text("ปานกลาง", textAlign: TextAlign.center),
                      Text("มาก", textAlign: TextAlign.center),
                      Text("มากที่สุด", textAlign: TextAlign.center),
                    ],
                  )
                : EmptyBox(heightFactor: 0),
            Container(
              padding: EdgeInsets.all(8),
              child: Text(
                item.name,
                style: TextStyle(
                  fontSize: 18,
                  color: Color(AppData.purpleColor),
                ),
              ),
            ),
            Table(
              children: [
                TableRow(
                  children: [
                    TableCell(
                      child: Container(
                        alignment: Alignment.center,
                        constraints: BoxConstraints(minHeight: 25, maxHeight: 25),
                        width: deviceSize.width,
                        child: RadioGroup<String>.builder(
                          horizontalAlignment: MainAxisAlignment.spaceBetween,
                          spacebetween: 0.1,
                          direction: Axis.horizontal,
                          groupValue: _selectedValue[index],
                          onChanged: (value) => setState(() {
                            _selectedValue[index] = value;
                            _selectedResult[index] = QuestionnaireAnswerModel(
                              choiceId: item.id,
                              questionId: item.questionId,
                              value: value,
                            );
                          }),
                          items: _valueList,
                          itemBuilder: (item) => RadioButtonBuilder(""),
                        ),
                      ),
                    ),
                  ],
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }
}
