import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/notification_list/notification_list_bloc.dart';
import 'package:peasmartcare/models/notification_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';

class NotificationList extends StatefulWidget {
  @override
  _NotificationListState createState() => _NotificationListState();
}

class _NotificationListState extends State<NotificationList> {
  @override
  void initState() {
    context.read<NotificationListBloc>().add(NotificationListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<NotificationListBloc, NotificationListState>(
      listener: (context, state) {
        if (state is NotificationListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<NotificationListBloc, NotificationListState>(
        builder: (context, state) {
          if (state is NotificationListLoading) {
            return Loading();
          } else if (state is NotificationListLoaded) {
            List<NotificationModel> resultList = state.result;

            return Column(
              children: resultList.map((item) {
                return _buildTable(item);
              }).toList(),
            );
          } else if (state is NotificationListNotFound) {
            return Column(
              children: [
                SizedBox(height: 50),
                NotFoundBox(),
              ],
            );
          } else if (state is NotificationListError) {
            return Column(
              children: [
                SizedBox(height: 50),
                ErrorBox(
                  message: state.message,
                ),
              ],
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTable(NotificationModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      padding: const EdgeInsets.all(5),
      child: Card(
        elevation: 3,
        child: Container(
          padding: EdgeInsets.all(15),
          width: deviceSize.width - 40,
          child: Table(
            columnWidths: {0: FixedColumnWidth(120)},
            children: [
              TableRow(
                children: [
                  TableCell(
                    child: Text("หมายเลขผู้ใช้ไฟฟ้า"),
                  ),
                  TableCell(
                    child: Text(item.caNumber),
                  ),
                ],
              ),
              TableRow(
                children: [
                  TableCell(
                    child: Text("ลูกค้า"),
                  ),
                  TableCell(
                    child: Text(item.customerName),
                  ),
                ],
              ),
              TableRow(
                children: [
                  TableCell(
                    child: Text("รายละเอียด"),
                  ),
                  TableCell(
                    child: item.type.contains("chat") ? Text(item.title) : Text(item.detail),
                  ),
                ],
              ),
              TableRow(
                children: [
                  TableCell(
                    child: Text("วันที่"),
                  ),
                  TableCell(
                    child: Text(item.dateTime),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
