import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/home_app_bar/home_app_bar_bloc.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/pea_bottom_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/components/customer_info.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/contact_staff/contact_staff.dart';
import 'package:peasmartcare/pages/home/home_left_sidebar_menu.dart';
import 'package:peasmartcare/pages/home/home_menu.dart';
import 'package:peasmartcare/components/notification_firebase.dart';
import 'package:permission_handler/permission_handler.dart';

class HomePage extends StatefulWidget {
  @override
  _HomePageState createState() => _HomePageState();
}

class _HomePageState extends State<HomePage> {
  final GlobalKey<ScaffoldState> _drawerKey = GlobalKey();

  final FirebaseMessaging _firebaseMessaging = FirebaseMessaging();
  NotificationFirebase _notification;

  @override
  void initState() {
    context.read<HomeAppBarBloc>().add(HomeAppBarGetData());

    super.initState();

    _notification = NotificationFirebase(context: context, firebaseMessaging: _firebaseMessaging);

    _notification.initNotificationFirebase();
  }

  @override
  Widget build(BuildContext context) {
    _allowPermission();

    return Scaffold(
      key: _drawerKey,
      drawer: HomeLeftSidebarMenu(),
      appBar: PEAAppBar(
        leading: Stack(
          children: <Widget>[
            ProfileAvatar(),
          ],
        ),
        title: BlocBuilder<HomeAppBarBloc, HomeAppBarState>(builder: (context, state) {
          if (state is HomeAppBarLoaded) {
            return Text(state.result);
          }

          return Text("");
        }),
        actions: <Widget>[
          IconButton(
            icon: Icon(Icons.dehaze),
            onPressed: () {
              _drawerKey.currentState.openDrawer();
            },
            tooltip: MaterialLocalizations.of(context).openAppDrawerTooltip,
          ),
        ],
      ),
      bottomNavigationBar: PEABottomBar(initialActiveIndex: 0),
      body: BodyLayout(
        header: CustomerInfo(),
        child: Column(
          children: <Widget>[
            InkWell(
              child: Container(
                constraints: BoxConstraints(minWidth: 350, maxWidth: 350),
                height: 80,
                child: Card(
                  color: Color(AppData.yellowColor),
                  child: Padding(
                    padding: const EdgeInsets.all(15),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceAround,
                      children: <Widget>[
                        Text(
                          "ติดต่อพนักงานดูแลลูกค้า",
                          style: TextStyle(
                            color: Color(AppData.purpleColor),
                            fontWeight: FontWeight.bold,
                            fontSize: 24,
                          ),
                        ),
                        Image.asset(ImageAsset.contactStaffImg, height: 40)
                      ],
                    ),
                  ),
                ),
              ),
              onTap: () {
                Navigator.push(
                  context,
                  MaterialPageRoute(builder: (context) => ContactStaffPage()),
                );
              },
            ),
            // _menu(),
            HomeMenu(),
          ],
        ),
      ),
    );
  }

  _allowPermission() async {
    final platform = Theme.of(context).platform;
    if (platform == TargetPlatform.android) {
      final status = await Permission.storage.status;
      if (status != PermissionStatus.granted) {
        await Permission.storage.request();
      }
    }

    final locationStatus = await Permission.location.status;
    if (locationStatus != PermissionStatus.granted) {
      await Permission.location.request();
    }
  }
}
