import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import 'package:peasmartcare/blocs/history_bill_detail_list/history_bill_detail_list_bloc.dart';
import 'package:peasmartcare/models/history_bill_detail_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/utils/app_util.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';

class HistoryBillDetailList extends StatefulWidget {
  @override
  _HistoryBillDetailListState createState() => _HistoryBillDetailListState();
}

class _HistoryBillDetailListState extends State<HistoryBillDetailList> {
  var totalAmountFormat = NumberFormat("#,##0.00", "en_US");
  double totalAmount = 0.00;

  @override
  void initState() {
    context.read<HistoryBillDetailListBloc>().add(HistoryBillDetailListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<HistoryBillDetailListBloc, HistoryBillDetailListState>(
      listener: (context, state) {
        if (state is HistoryBillDetailListLoaded) {
          List<HistoryBillDetailModel> resultList = state.result;
          resultList.map((item) {
            setState(() {
              totalAmount = AppUtil.toNumeric(item.amount) + totalAmount;
            });
          }).toList();
        } else if (state is HistoryBillDetailListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<HistoryBillDetailListBloc, HistoryBillDetailListState>(
        builder: (context, state) {
          if (state is HistoryBillDetailListLoading) {
            return Loading();
          } else if (state is HistoryBillDetailListLoaded) {
            List<HistoryBillDetailModel> resultList = state.result;
            return Column(
              children: resultList.map((item) {
                return Column(
                  children: [
                    _buildTable(item),
                    Container(
                      padding: EdgeInsets.all(8),
                      child: Text("รวมยอดชำระ ${totalAmountFormat.format(totalAmount)} บาท"),
                    ),
                  ],
                );
              }).toList(),
            );
          } else if (state is HistoryBillDetailListNotFound) {
            return NotFoundBox();
          } else if (state is HistoryBillDetailListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTable(HistoryBillDetailModel item) {
    Size deviceSize = MediaQuery.of(context).size;

    return Container(
      padding: const EdgeInsets.all(5),
      child: Card(
        elevation: 3,
        child: Container(
          padding: EdgeInsets.all(15),
          width: deviceSize.width - 40,
          child: Table(
            columnWidths: {0: FixedColumnWidth(100)},
            children: [
              TableRow(
                children: [
                  // TableCell(
                  //   child: Text("รายการ"),
                  // ),
                  TableCell(
                    child: Text(item.itemName ?? ""),
                  ),
                ],
              ),
              // TableRow(
              //   children: [
              //     TableCell(
              //       child: Text("จำนวน"),
              //     ),
              //     TableCell(
              //       child: Text("${item?.amount} ${item?.unit}" ?? ""),
              //     ),
              //   ],
              // ),
            ],
          ),
        ),
      ),
    );
  }
}
