import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/history_bill_detail_list/history_bill_detail_list_bloc.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/header_content.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/components/customer_info.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/history_bill_detail/history_bill_detail_list.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class HistoryBillDetail extends StatefulWidget {
  @override
  _HistoryBillDetailState createState() => _HistoryBillDetailState();
}

class _HistoryBillDetailState extends State<HistoryBillDetail> {
  RefreshController _refreshController = RefreshController(initialRefresh: false);

  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Scaffold(
      appBar: PEAAppBar(
        title: "รายละเอียดประวัติการชำระเงิน",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      body: BodyLayout(
        header: CustomerInfo(),
        onPullRefresh: _onRefresh,
        refreshController: _refreshController,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "รายละเอียดประวัติการชำระเงิน",
                  icon: ImageAsset.historyBillImg,
                ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 90),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            HistoryBillDetailList(),
          ],
        ),
      ),
    );
  }

  Future<void> _onRefresh() async {
    context.read<HistoryBillDetailListBloc>().add(HistoryBillDetailListGetList());

    await Future.delayed(Duration(milliseconds: 1000));
    _refreshController.refreshCompleted();
  }
}
