import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import 'package:peasmartcare/blocs/history_bill_detail_list/history_bill_detail_list_bloc.dart';
import 'package:peasmartcare/blocs/history_bill_list/history_bill_list_bloc.dart';
import 'package:peasmartcare/models/history_bill_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/pages/history_bill_detail/history_bill_detail.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';

class HistoryBillList extends StatefulWidget {
  @override
  _HistoryBillListState createState() => _HistoryBillListState();
}

class _HistoryBillListState extends State<HistoryBillList> {
  @override
  void initState() {
    context.read<HistoryBillListBloc>().add(HistoryBillListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<HistoryBillListBloc, HistoryBillListState>(
      listener: (context, state) {
        if (state is HistoryBillListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<HistoryBillListBloc, HistoryBillListState>(
        builder: (context, state) {
          if (state is HistoryBillListLoading) {
            return Loading();
          } else if (state is HistoryBillListLoaded) {
            List<HistoryBillModel> resultList = state.result;
            return Column(
              children: resultList.map((item) {
                return _buildTable(item);
              }).toList(),
            );
          } else if (state is HistoryBillListNotFound) {
            return NotFoundBox();
          } else if (state is HistoryBillListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTable(HistoryBillModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return InkWell(
      child: Container(
        padding: const EdgeInsets.all(5),
        child: Card(
          elevation: 3,
          child: Container(
            padding: EdgeInsets.all(15),
            // height: 100,
            width: deviceSize.width - 40,
            child: Table(
              columnWidths: {1: FixedColumnWidth(30)},
              children: [
                TableRow(
                  children: [
                    TableCell(
                      child: Table(
                        columnWidths: {0: FixedColumnWidth(100)},
                        children: [
                          TableRow(
                            children: [
                              TableCell(
                                child: Text("รอบบิล"),
                              ),
                              TableCell(
                                child: Text(item.billMonth ?? ""),
                              ),
                            ],
                          ),
                          TableRow(
                            children: [
                              TableCell(
                                child: Text("จำนวนหน่วย"),
                              ),
                              TableCell(
                                child: Text("${(item.unitUsed ?? "")} หน่วย"),
                              ),
                            ],
                          ),
                          TableRow(
                            children: [
                              TableCell(
                                child: Text("ยอดชำระ"),
                              ),
                              TableCell(
                                child: Text(item.amount + " บาท" ?? ""),
                              ),
                            ],
                          ),
                          TableRow(
                            children: [
                              TableCell(
                                child: Text("กำหนดชำระ"),
                              ),
                              TableCell(
                                child: Text(item.dueDate ?? ""),
                              ),
                            ],
                          ),
                          TableRow(
                            children: [
                              TableCell(
                                child: Text("วันที่ชำระ"),
                              ),
                              TableCell(
                                child: Text(item.paymentDate ?? ""),
                              ),
                            ],
                          ),
                          TableRow(
                            children: [
                              TableCell(
                                child: Text("ช่องทาง"),
                              ),
                              TableCell(
                                child: Text(item.paymentChannel ?? ""),
                              ),
                            ],
                          ),
                        ],
                      ),
                    ),
                    TableCell(
                      verticalAlignment: TableCellVerticalAlignment.middle,
                      child: Icon(Icons.arrow_forward_ios),
                    ),
                  ],
                ),
              ],
            ),
          ),
        ),
      ),
      onTap: () {
        context.read<HistoryBillDetailListBloc>().add(
              HistoryBillDetailListAddDetail(details: item.historyBillDetails),
            );
        Navigator.push(
          context,
          MaterialPageRoute(builder: (context) => HistoryBillDetail()),
        );
      },
    );
  }
}
