import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/customer_info.dart';
import 'package:peasmartcare/components/header_content.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/pea_bottom_bar.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/news/news_list.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class ExamPullDown extends StatefulWidget {
  @override
  _ExamPullDownState createState() => _ExamPullDownState();
}

class _ExamPullDownState extends State<ExamPullDown> {
  List<String> items = ["1", "2", "3", "4", "5", "6", "7", "8"];
  RefreshController _refreshController = RefreshController(initialRefresh: false);

  Future<void> _onRefresh() async {

    await Future.delayed(Duration(milliseconds: 1000));
    // if failed,use refreshFailed()
    _refreshController.refreshCompleted();
    // _refreshController.loadComplete();

  }

  _onLoading() async {
    // monitor network fetch
    await Future.delayed(Duration(milliseconds: 1000));
    // if failed,use loadFailed(),if no data return,use LoadNodata()
    items.add((items.length + 1).toString());
    if (mounted) setState(() {});
    _refreshController.loadComplete();
  }

  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Scaffold(
      appBar: PEAAppBar(
        title: "ตัวอย่าง Pull Down",
        actions: <Widget>[],
      ),
      bottomNavigationBar: PEABottomBar(),
      body: BodyLayout(
        refreshController: _refreshController,
        top: deviceSize.width > 500 ? 150 : 180,
        header: CustomerInfo(),
        onPullRefresh: _onRefresh,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "ข่าวประชาสัมพันธ์",
                  icon: ImageAsset.newsImg,
                ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 70),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            // NewsFeaturedList(),
            Text("aaaaaaaa\n\n\n\n\n\n\n\n\n\nssssssssssss"),
            NewsList(),
          ],
        ),
      ),
    );
  }
}
