import 'package:flutter/material.dart';
import 'package:flutter_map/flutter_map.dart';
import 'package:flutter_map/plugin_api.dart';
import 'package:latlong/latlong.dart';
import 'package:peasmartcare/blocs/electricity_location_save/electricity_location_save_bloc.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/sweetalert/sweetalert.dart';

class LoadingLocationPluginOption extends LayerOptions {
  final Alignment alignment;
  final MapController mapController;
  final LatLng currentLatLng;

  LoadingLocationPluginOption({
    Key key,
    this.alignment = Alignment.topRight,
    this.mapController,
    this.currentLatLng,
    rebuild,
  }) : super(key: key, rebuild: rebuild);
}

class LoadingLocationPlugin implements MapPlugin {
  @override
  Widget createLayer(LayerOptions options, MapState mapState, Stream<Null> stream) {
    if (options is LoadingLocationPluginOption) {
      return LoadingLocationButton(options, mapState, stream);
    }
    throw Exception('Unknown options type for LoadingLocationPlugin: $options');
  }

  @override
  bool supportsLayer(LayerOptions options) {
    return options is LoadingLocationPluginOption;
  }
}

class LoadingLocationButton extends StatelessWidget {
  final LoadingLocationPluginOption currentLocationButtonsOpts;
  final MapState map;
  final Stream<Null> stream;
  final FitBoundsOptions options = const FitBoundsOptions(padding: EdgeInsets.all(12.0));

  LoadingLocationButton(this.currentLocationButtonsOpts, this.map, this.stream) : super(key: currentLocationButtonsOpts.key);

  @override
  Widget build(BuildContext context) {
    return Align(
      alignment: currentLocationButtonsOpts.alignment,
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: <Widget>[
          Padding(
            padding: EdgeInsets.all(8),
            child: BlocListener<ElectricityLocationSaveBloc, ElectricityLocationSaveState>(
              listener: (context, state) {
                if (state is ElectricityLocationSaveLoaded) {
                  if (state.saveSuccess != null && state.saveSuccess) {
                    SweetAlert.show(
                      context,
                      subtitle: "บันทึกแผนที่สำเร็จ",
                      style: SweetAlertStyle.success,
                      showCancelButton: false,
                      onPress: (bool isConfirm) {
                        return true;
                      },
                    );
                  } else if (state.saveSuccess != null && !state.saveSuccess) {
                    SweetAlert.show(
                      context,
                      subtitle: "บันทึกแผนที่ไม่สำเร็จ",
                      style: SweetAlertStyle.error,
                    );
                  }
                } else if (state is ElectricityLocationSaveErrorUnauthorized) {
                  Navigator.of(context).popUntil((route) => route.isFirst);
                  Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(builder: (context) => LogoutPage()),
                  );
                }
              },
              child: BlocBuilder<ElectricityLocationSaveBloc, ElectricityLocationSaveState>(
                builder: (context, state) {
                  if (state is ElectricityLocationSaveLoading) {
                    return Padding(
                      padding: const EdgeInsets.only(top: 30),
                      child: Loading(height: 20),
                    );
                  }

                  return EmptyBox();
                  // return Row(
                  //   mainAxisAlignment: MainAxisAlignment.center,
                  //   children: <Widget>[
                  //     Container(
                  //       padding: EdgeInsets.fromLTRB(0, 30, 0, 15),
                  //       child: RaisedButton(
                  //         padding: EdgeInsets.only(top: 12, left: 30, right: 30, bottom: 12),
                  //         shape: RoundedRectangleBorder(
                  //           borderRadius: BorderRadius.circular(7),
                  //         ),
                  //         child: Text(
                  //           "บันทึก",
                  //           style: TextStyle(
                  //             fontWeight: FontWeight.w800,
                  //             color: Colors.white,
                  //             fontSize: 18,
                  //           ),
                  //         ),
                  //         color: Color(AppData.yellowColor),
                  //         onPressed: () {
                  //           context.read<ElectricityLocationSaveBloc>().add(
                  //                 ElectricityLocationSaveOnSubmit(
                  //                   latitude: _currentLatLng.latitude,
                  //                   longitude: _currentLatLng.longitude,
                  //                 ),
                  //               );
                  //         },
                  //       ),
                  //     ),
                  //   ],
                  // );
                },
              ),
            ),
          ),
        ],
      ),
    );
  }
}
