import 'package:flutter/material.dart';
import 'package:flutter_map/flutter_map.dart';
import 'package:flutter_map/plugin_api.dart';
import 'package:latlong/latlong.dart';
import 'package:peasmartcare/constraints/app_data.dart';

class CurrentLocationPluginOption extends LayerOptions {
  final Alignment alignment;
  final MapController mapController;
  final LatLng currentLatLng;

  CurrentLocationPluginOption({
    Key key,
    this.alignment = Alignment.topRight,
    this.mapController,
    this.currentLatLng,
    rebuild,
  }) : super(key: key, rebuild: rebuild);
}

class CurrentLocationPlugin implements MapPlugin {
  @override
  Widget createLayer(LayerOptions options, MapState mapState, Stream<Null> stream) {
    if (options is CurrentLocationPluginOption) {
      return CurrentLocationButton(options, mapState, stream);
    }
    throw Exception('Unknown options type for CurrentLocationPlugin: $options');
  }

  @override
  bool supportsLayer(LayerOptions options) {
    return options is CurrentLocationPluginOption;
  }
}

class CurrentLocationButton extends StatelessWidget {
  final CurrentLocationPluginOption currentLocationButtonsOpts;
  final MapState map;
  final Stream<Null> stream;
  final FitBoundsOptions options = const FitBoundsOptions(padding: EdgeInsets.all(12.0));

  CurrentLocationButton(this.currentLocationButtonsOpts, this.map, this.stream) : super(key: currentLocationButtonsOpts.key);

  @override
  Widget build(BuildContext context) {
    return Align(
      alignment: currentLocationButtonsOpts.alignment,
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: <Widget>[
          Padding(
            padding: EdgeInsets.all(8),
            child: FloatingActionButton(
              heroTag: 'currentLocationButton',
              backgroundColor: Color(AppData.blueColor),
              onPressed: () {
                currentLocationButtonsOpts.mapController.move(
                  currentLocationButtonsOpts.currentLatLng,
                  15,
                );
              },
              child: Icon(
                Icons.gps_not_fixed,
                color: Color(AppData.whiteColor),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
