import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/electricity_location_list/electricity_location_list_bloc.dart';
import 'package:peasmartcare/models/electricity_location_customer_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';

class ElectricityLocationList extends StatefulWidget {
  @override
  _ElectricityLocationListState createState() => _ElectricityLocationListState();
}

class _ElectricityLocationListState extends State<ElectricityLocationList> {
  @override
  void initState() {
    context.read<ElectricityLocationListBloc>().add(ElectricityLocationListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<ElectricityLocationListBloc, ElectricityLocationListState>(
      listener: (context, state) {
        if (state is ElectricityLocationListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<ElectricityLocationListBloc, ElectricityLocationListState>(
        builder: (context, state) {
          if (state is ElectricityLocationListLoading) {
            return Loading();
          } else if (state is ElectricityLocationListLoaded) {
            List<ElectricityLocationCustomerModel> resultList = state.result;
            return Column(
              children: resultList.map((item) {
                return _buildTable(item);
              }).toList(),
            );
          } else if (state is ElectricityLocationListNotFound) {
            return NotFoundBox();
          } else if (state is ElectricityLocationListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTable(ElectricityLocationCustomerModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      padding: const EdgeInsets.all(5),
      child: Card(
        elevation: 3,
        child: Container(
          padding: EdgeInsets.all(15),
          width: deviceSize.width - 40,
          child: Table(
            columnWidths: {0: FixedColumnWidth(80)},
            children: [
              TableRow(
                children: [
                  TableCell(
                    child: Text(item.caNumber ?? ""),
                  ),
                ],
              ),
              TableRow(
                children: [
                  TableCell(
                    child: Text(item.customerName ?? ""),
                  ),
                ],
              ),
              TableRow(
                children: [
                  TableCell(
                    child: Text(item.address ?? ""),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
