import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/electricity_location_list/electricity_location_list_bloc.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/header_content.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/pea_bottom_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/electricity_location/electricity_location_map.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class ElectricityLocationPage extends StatefulWidget {
  @override
  _ElectricityLocationPageState createState() => _ElectricityLocationPageState();
}

class _ElectricityLocationPageState extends State<ElectricityLocationPage> {
  RefreshController _refreshController = RefreshController(initialRefresh: false);

  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Scaffold(
      appBar: PEAAppBar(
        title: "ระบุที่ตั้งสำนักงาน",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      bottomNavigationBar: PEABottomBar(),
      body: BodyLayout(
        top: 0,
        layoutType: LayoutType.ONLY_CHILD,
        // onPullRefresh: _onRefresh,
        // refreshController: _refreshController,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "ระบุที่ตั้งสำนักงาน",
                  icon: ImageAsset.contactLocationImg,
                ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 70),
        child: ElectricityLocationMap(),
      ),
    );
  }

  Future<void> _onRefresh() async {
    context.read<ElectricityLocationListBloc>().add(ElectricityLocationListGetList());

    await Future.delayed(Duration(milliseconds: 1000));
    _refreshController.refreshCompleted();
  }
}
