import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/contact_staff/contact_staff_list_bloc.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/header_content.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/pea_bottom_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/contact_staff/contact_staff_list.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class ContactStaffPage extends StatefulWidget {
  @override
  _ContactStaffPageState createState() => _ContactStaffPageState();
}

class _ContactStaffPageState extends State<ContactStaffPage> {
  RefreshController _refreshController = RefreshController(initialRefresh: false);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: PEAAppBar(
        title: "ติดต่อพนักงานดูแลลูกค้า",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      bottomNavigationBar: PEABottomBar(initialActiveIndex: 2),
      body: BodyLayout(
        top: 0,
        onPullRefresh: _onRefresh,
        refreshController: _refreshController,
        layoutType: LayoutType.ONLY_CHILD,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "ติดต่อพนักงานดูแลลูกค้า",
                  icon: ImageAsset.contactStaffImg,
                ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 70),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[ContactStaffList()],
        ),
      ),
    );
  }

  Future<void> _onRefresh() async {
    context.read<ContactStaffListBloc>().add(ContactStaffListGetList());
    await Future.delayed(Duration(milliseconds: 1000));
    _refreshController.refreshCompleted();
  }
}
