import 'package:flutter/material.dart';
import 'package:peasmartcare/components/chat/chat.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/utils/clear_count_notification_util.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

class GroupChat extends StatefulWidget {
  final String typeChat;
  final String chatMasterId;
  final String typeAccount;

  const GroupChat({
    Key key,
    this.typeChat,
    this.chatMasterId,
    this.typeAccount,
  }) : super(key: key);

  _GroupChatState createState() => _GroupChatState();
}

class _GroupChatState extends State<GroupChat> {
  @override
  void initState() {
    ClearCountNotificationUtil.chat(widget.chatMasterId);

    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: PEAAppBar(
        title: "ห้องสนทนารวม",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      body: Chat(
        userId: ShareDataUtil.getUserId(),
        isGroupChat: true,
        typeChat: AppData.groupChatTypeChat,
        chatMasterId: AppData.groupChatChatMasterId,
        typeAccount: AppData.groupChatTypeAccount,
      ),
    );
  }
}
