import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_swiper/flutter_swiper.dart';
import 'package:peasmartcare/blocs/additional_service_detail/additional_service_detail_bloc.dart';
import 'package:peasmartcare/blocs/additional_service_list/additional_service_list_bloc.dart';
import 'package:peasmartcare/models/additional_service_model.dart';
import 'package:peasmartcare/pages/additional_service/additional_service_detail.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/image_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';

class AdditionalServiceList extends StatefulWidget {
  @override
  _AdditionalServiceListState createState() => _AdditionalServiceListState();
}

class _AdditionalServiceListState extends State<AdditionalServiceList> {
  @override
  void initState() {
    context.read<AdditionalServiceListBloc>().add(AdditionalServiceListGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<AdditionalServiceListBloc, AdditionalServiceListState>(
      listener: (context, state) {
        if (state is AdditionalServiceListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<AdditionalServiceListBloc, AdditionalServiceListState>(
        builder: (context, state) {
          if (state is AdditionalServiceListLoading) {
            return Loading();
          } else if (state is AdditionalServiceListLoaded) {
            List<AdditionalServiceModel> resultList = state.result;
            return _buildList(resultList); //_buildSlide(resultList);
          } else if (state is AdditionalServiceListNotFound) {
            return NotFoundBox();
          } else if (state is AdditionalServiceListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Column _buildSlide(List<AdditionalServiceModel> itemList) {
    return Column(
      children: <Widget>[
        Container(
          height: 340,
          padding: EdgeInsets.all(16.0),
          child: Swiper(
            autoplay: true,
            fade: 0.0,
            itemBuilder: (BuildContext context, int index) {
              return InkWell(
                child: Column(
                  children: <Widget>[
                    ImageBox(
                      height: 200,
                      src: itemList[index].image,
                      borderRadius: BorderRadius.only(topLeft: Radius.circular(10), topRight: Radius.circular(10)),
                    ),
                    Container(
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.only(
                          bottomLeft: Radius.circular(10),
                          bottomRight: Radius.circular(10),
                        ),
                      ),
                      child: ListTile(
                        title: AutoSizeText(itemList[index].subject, maxLines: 2),
                        // subtitle: Text(newsList[index].dateTime),
                      ),
                    )
                  ],
                ),
                onTap: () {
                  context.read<AdditionalServiceDetailBloc>().add(
                        AdditionalServiceDetailAddId(id: itemList[index].id),
                      );
                  Navigator.push(
                    context,
                    MaterialPageRoute(builder: (context) => AdditionalServiceDetail()),
                  );
                },
              );
            },
            itemCount: itemList.length,
            viewportFraction: 0.78,
            scale: 0.9,
            pagination: SwiperPagination(),
          ),
        ),
      ],
    );
  }

  Widget _buildList(List<AdditionalServiceModel> itemList) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      height: 350,
      padding: const EdgeInsets.all(15),
      child: ListView.builder(
        itemCount: itemList.length,
        itemBuilder: (context, index) {
          return InkWell(
            child: Container(
              padding: const EdgeInsets.all(5),
              child: Card(
                elevation: 3,
                child: Row(
                  children: <Widget>[
                    ImageBox(
                      height: 130,
                      width: 130,
                      src: itemList[index].image,
                      borderRadius: BorderRadius.only(topLeft: Radius.circular(3), bottomLeft: Radius.circular(3)),
                    ),
                    Container(
                      padding: EdgeInsets.all(15),
                      height: 130,
                      width: deviceSize.width - 185,
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.spaceAround,
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          AutoSizeText(itemList[index].subject, maxLines: 3),
                          // Text(dateTime),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            ),
            onTap: () {
              context.read<AdditionalServiceDetailBloc>().add(
                    AdditionalServiceDetailAddId(id: itemList[index].id),
                  );
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => AdditionalServiceDetail()),
              );
            },
          );
        },
      ),
    );
  }
}
