import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_slidable/flutter_slidable.dart';
import 'package:peasmartcare/blocs/additional_service_history/additional_service_history_bloc.dart';
import 'package:peasmartcare/models/additional_service_history_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';
import 'package:peasmartcare/widgets/sweetalert/sweetalert.dart';

class AdditionalServiceHistory extends StatefulWidget {
  @override
  _AdditionalServiceHistoryState createState() => _AdditionalServiceHistoryState();
}

class _AdditionalServiceHistoryState extends State<AdditionalServiceHistory> {
  @override
  void initState() {
    context.read<AdditionalServiceHistoryBloc>().add(AdditionalServiceHistoryGetList());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<AdditionalServiceHistoryBloc, AdditionalServiceHistoryState>(
      listener: (context, state) {
        if (state is AdditionalServiceHistoryLoaded) {
          if (state.deleteSuccess != null && state.deleteSuccess) {
            SweetAlert.show(
              context,
              subtitle: "ลบข้อมูลสำเร็จ",
              style: SweetAlertStyle.success,
              onPress: (bool isConfirm) {
                if (isConfirm) {
                  context.read<AdditionalServiceHistoryBloc>().add(AdditionalServiceHistoryGetList());
                  Navigator.pop(context);

                  return false;
                }
              },
            );
          } else if (state.deleteSuccess != null && !state.deleteSuccess) {
            SweetAlert.show(
              context,
              subtitle: "ลบข้อมูลไม่สำเร็จ",
              style: SweetAlertStyle.error,
            );
          }
        } else if (state is AdditionalServiceHistoryErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<AdditionalServiceHistoryBloc, AdditionalServiceHistoryState>(
        builder: (context, state) {
          if (state is AdditionalServiceHistoryLoading) {
            return Loading();
          } else if (state is AdditionalServiceHistoryLoaded) {
            List<AdditionalServiceHistoryModel> resultList = state.result;
            return Container(
              width: double.infinity,
              margin: EdgeInsets.only(top: 80),
              child: Column(
                // mainAxisAlignment: MainAxisAlignment.center,
                // crossAxisAlignment: CrossAxisAlignment.center,
                children: resultList.map((item) {
                  return Slidable(
                    enabled: false, //item.statusId == 1,
                    actionPane: SlidableBehindActionPane(),
                    actionExtentRatio: 0.25,
                    child: _buildList(item),
                    secondaryActions: <Widget>[
                      Container(
                        padding: EdgeInsets.only(top: 5, bottom: 5),
                        child: Card(
                          child: IconSlideAction(
                            color: Colors.red,
                            icon: Icons.delete,
                            onTap: () {
                              SweetAlert.show(
                                context,
                                title: "ต้องการลบข้อมูลใช่หรือไม่",
                                style: SweetAlertStyle.confirm,
                                showCancelButton: true,
                                onPress: (bool isConfirm) {
                                  if (isConfirm) {
                                    context.read<AdditionalServiceHistoryBloc>().add(
                                          AdditionalServiceHistoryOnDelete(id: item.prId),
                                        );
                                    Navigator.pop(context);
                                    return false;
                                  }
                                },
                              );
                            },
                          ),
                        ),
                      ),
                    ],
                  );
                }).toList(),
              ),
            );
          } else if (state is AdditionalServiceHistoryNotFound) {
            return NotFoundBox();
          } else if (state is AdditionalServiceHistoryError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildList(AdditionalServiceHistoryModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      padding: const EdgeInsets.all(5),
      child: Card(
        elevation: 3,
        child: Container(
          padding: EdgeInsets.all(15),
          width: deviceSize.width - 40,
          child: Table(
            columnWidths: {1: FixedColumnWidth(120)},
            children: [
              TableRow(
                children: [
                  TableCell(
                    verticalAlignment: TableCellVerticalAlignment.middle,
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          item.subject ?? "",
                          // overflow: TextOverflow.ellipsis,
                        ),
                        Text(item.createBy ?? ""),
                        Text(item.createDate ?? ""),
                      ],
                    ),
                  ),
                  TableCell(
                    verticalAlignment: TableCellVerticalAlignment.middle,
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: <Widget>[
                        Text(
                          item.statusName ?? "",
                          style: TextStyle(fontSize: 13),
                        ),
                        (item.statusId == 1)
                            ? Padding(
                                padding: const EdgeInsets.only(left: 10),
                                child: InkWell(
                                  child: Icon(
                                    Icons.delete,
                                    color: Colors.red,
                                  ),
                                  onTap: () {
                                    SweetAlert.show(
                                      context,
                                      title: "ต้องการลบข้อมูลใช่หรือไม่",
                                      style: SweetAlertStyle.confirm,
                                      showCancelButton: true,
                                      onPress: (bool isConfirm) {
                                        if (isConfirm) {
                                          context.read<AdditionalServiceHistoryBloc>().add(
                                                AdditionalServiceHistoryOnDelete(id: item.prId),
                                              );
                                          Navigator.pop(context);
                                          return false;
                                        }
                                      },
                                    );
                                  },
                                ),
                              )
                            : EmptyBox(heightFactor: 0),
                      ],
                    ),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
