import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/additional_service_history/additional_service_history_bloc.dart';
import 'package:peasmartcare/blocs/additional_service_list/additional_service_list_bloc.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/customer_info.dart';
import 'package:peasmartcare/components/header_content.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/pea_bottom_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/additional_service/additional_service_history.dart';
import 'package:peasmartcare/pages/additional_service/additional_service_list.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class AdditionalServicePage extends StatefulWidget {
  @override
  _AdditionalServicePageState createState() => _AdditionalServicePageState();
}

class _AdditionalServicePageState extends State<AdditionalServicePage> {
  RefreshController _refreshController = RefreshController(initialRefresh: false);

  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Scaffold(
      appBar: PEAAppBar(
        title: "ขอใช้บริการเสริม",
        actions: <Widget>[
          ProfileAvatar(),
        ],
      ),
      bottomNavigationBar: PEABottomBar(),
      body: BodyLayout(
        header: CustomerInfo(),
        onPullRefresh: _onRefresh,
        refreshController: _refreshController,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "ขอใช้บริการเสริม",
                  icon: ImageAsset.reportIncidentImg,
                ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 70),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            AdditionalServiceList(),
            Stack(
              children: <Widget>[
                HeaderContent(
                  title: "ประวัติคำขอใช้บริการเสริม",
                  icon: ImageAsset.reportIncidentImg,
                  maxLines: 1,
                ),
                Positioned(
                  child: AdditionalServiceHistory(),
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Future<void> _onRefresh() async {
    context.read<AdditionalServiceListBloc>().add(AdditionalServiceListGetList());

    context.read<AdditionalServiceHistoryBloc>().add(AdditionalServiceHistoryGetList());
    await Future.delayed(Duration(milliseconds: 1000));
    _refreshController.refreshCompleted();
  }
}
