import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/activity_list/activity_list_bloc.dart';
import 'package:peasmartcare/models/activity_model.dart';
import 'package:peasmartcare/pages/auth/logout.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';
import 'package:peasmartcare/widgets/not_found_box.dart';

class ActivityList extends StatefulWidget {
  @override
  _ActivityListState createState() => _ActivityListState();
}

class _ActivityListState extends State<ActivityList> {
  @override
  void initState() {
    context.read<ActivityListBloc>().add(ActivityListGetList());

    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocListener<ActivityListBloc, ActivityListState>(
      listener: (context, state) {
        if (state is ActivityListErrorUnauthorized) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.pushReplacement(
            context,
            MaterialPageRoute(builder: (context) => LogoutPage()),
          );
        }
      },
      child: BlocBuilder<ActivityListBloc, ActivityListState>(
        builder: (context, state) {
          if (state is ActivityListLoading) {
            return Loading();
          } else if (state is ActivityListLoaded) {
            List<ActivityModel> resultList = state.result;
            return Column(
              children: resultList.map((item) {
                return _buildTable(item);
              }).toList(),
            );
          } else if (state is ActivityListNotFound) {
            return NotFoundBox();
          } else if (state is ActivityListError) {
            return ErrorBox(
              message: state.message,
            );
          }

          return EmptyBox();
        },
      ),
    );
  }

  Widget _buildTable(ActivityModel item) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      padding: const EdgeInsets.all(5),
      child: Card(
        elevation: 3,
        child: Container(
          padding: EdgeInsets.all(15),
          width: deviceSize.width - 40,
          child: Table(
            columnWidths: {0: FixedColumnWidth(80)},
            children: [
              TableRow(
                children: [
                  TableCell(
                    child: Text("เรื่อง"),
                  ),
                  TableCell(
                    child: Text(item.subject),
                  ),
                ],
              ),
              TableRow(
                children: [
                  TableCell(
                    child: Text("วันเวลา"),
                  ),
                  TableCell(
                    child: Text("${item.startDate} - ${item.endDate}"),
                  ),
                ],
              ),
              TableRow(
                children: [
                  TableCell(
                    child: Text("สถานที่"),
                  ),
                  TableCell(
                    child: Text(item.location),
                  ),
                ],
              ),
              // TableRow(
              //   children: [
              //     TableCell(
              //       child: Text("ประเภทกิจกรรม"),
              //     ),
              //     TableCell(
              //       child: Text(item.activityType),
              //     ),
              //   ],
              // ),
            ],
          ),
        ),
      ),
    );
  }
}
