import 'package:flutter/material.dart';
import 'package:package_info/package_info.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/constraints/image_asset.dart';

class AboutUsPage extends StatefulWidget {
  @override
  _AboutUsPageState createState() => _AboutUsPageState();
}

class _AboutUsPageState extends State<AboutUsPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: PEAAppBar(
        title: "เกี่ยวกับโปรแกรม",
        actions: <Widget>[],
      ),
      body: BodyLayout(
        top: 0,
        layoutType: LayoutType.ONLY_CHILD,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    bool isPortrait = MediaQuery.of(context).orientation == Orientation.portrait;
    return Padding(
      padding: const EdgeInsets.only(top: 40),
      child: Container(
        // height: 800,
        child: Center(
          child: Column(
            children: <Widget>[
              Container(
                alignment: Alignment.topCenter,
                child: Image.asset(
                  ImageAsset.peaHorizontalLogo,
                  width: 350,
                  fit: BoxFit.fill,
                ),
              ),
              SizedBox(height: 80),
              FutureBuilder(
                future: _getVersionNumber(),
                builder: (BuildContext context, AsyncSnapshot<String> snapshot) => Text(
                  snapshot.hasData ? "เวอร์ชัน ${snapshot.data}" : "",
                  style: TextStyle(color: Color(isPortrait ? AppData.purpleColor : AppData.yellowColor), fontSize: 20),
                ),
              ),
              Text(
                "แจ้งปัญหาการใช้งาน โทร 1129",
                style: TextStyle(color: Color(isPortrait ? AppData.purpleColor : AppData.yellowColor), fontSize: 20),
              ),
              // SizedBox(height: 80),
              // Logout(),
            ],
          ),
        ),
      ),
    );
  }

  Future<String> _getVersionNumber() async {
    PackageInfo packageInfo = await PackageInfo.fromPlatform();
    // return "${packageInfo.version}";
    return "${packageInfo.version} (${packageInfo.buildNumber})";
  }
}
